/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import vtk.vtkCamera;
import vtk.vtkCanvas;
import vtk.vtkLight;
import vtk.vtkRenderWindow;

public class vtkRenderWindowPanel
extends vtkCanvas {
    private static final long serialVersionUID = 1L;

    public vtkRenderWindowPanel() {
        this.cam = new vtkCamera();
        this.lgt = new vtkLight();
    }

    public vtkRenderWindowPanel(vtkRenderWindow vtkRenderWindow2) {
        super(vtkRenderWindow2);
        this.cam = new vtkCamera();
        this.lgt = new vtkLight();
    }

    @Override
    public synchronized void Render() {
        if (!this.rendering) {
            this.rendering = true;
            if (this.rw != null) {
                if (this.windowset == 0) {
                    this.RenderCreate(this.rw);
                    this.Lock();
                    this.rw.SetSize(this.getWidth(), this.getHeight());
                    this.UnLock();
                    this.windowset = 1;
                }
                this.Lock();
                this.rw.Render();
                this.UnLock();
            }
            this.rendering = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.Lock();
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.ctrlPressed = (mouseEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.iren.LeftButtonPressEvent();
        } else if ((mouseEvent.getModifiers() & 8) == 8) {
            this.iren.MiddleButtonPressEvent();
        } else if ((mouseEvent.getModifiers() & 4) == 4) {
            this.iren.RightButtonPressEvent();
        }
        this.UnLock();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.ctrlPressed = (mouseEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        this.ctrlPressed = (keyEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (keyEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, c, 0, String.valueOf(c));
        this.Lock();
        this.iren.KeyPressEvent();
        this.iren.CharEvent();
        this.UnLock();
    }
}

