/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.handlers.configuration.ConfigurationHandler;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.BundleContext;

public class PropertyDescription {
    private String m_name;
    private String m_type;
    private String m_value = null;
    private Property m_property;
    private boolean m_immutable = false;
    private boolean m_isMandatory = false;

    public PropertyDescription(String name, String type, String value) {
        this.m_name = name;
        this.m_type = type;
        this.m_value = value;
    }

    public PropertyDescription(Property prop) {
        this.m_property = prop;
        this.m_name = prop.getName();
        this.m_type = prop.getType();
        this.m_value = null;
    }

    public PropertyDescription(String name, String type, String value, boolean immutable) {
        this.m_name = name;
        this.m_type = type;
        this.m_value = value;
        this.m_immutable = immutable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public String getValue() {
        if (this.m_property == null) {
            return this.m_value;
        }
        Object value = this.m_property.getValue();
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public void setValue(Object value) {
        if (this.m_property == null) {
            throw new UnsupportedOperationException("Cannot set the value of a non 'living' property");
        }
        ConfigurationHandler handler = (ConfigurationHandler)this.m_property.getHandler();
        handler.reconfigureProperty(this.m_property, value);
    }

    public boolean isImmutable() {
        return this.m_immutable;
    }

    public void setMandatory() {
        this.m_isMandatory = true;
    }

    public boolean isMandatory() {
        return this.m_isMandatory;
    }

    public Object getObjectValue(BundleContext context) {
        if (this.m_value == null) {
            return null;
        }
        Class type = null;
        try {
            type = Property.computeType(this.m_type, context);
            return Property.create(type, this.m_value);
        }
        catch (ConfigurationException e) {
            return this.m_value;
        }
    }
}

