/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    COMMON("vtkCommonJava"),
    FILTERING("vtkFilteringJava"),
    GEOVIS("vtkGeovisJava"),
    GRAPHICS("vtkGraphicsJava"),
    HYBRID("vtkHybridJava"),
    IMAGING("vtkImagingJava"),
    INFOVIS("vtkInfovisJava"),
    IO("vtkIOJava"),
    RENDERING("vtkRenderingJava"),
    VIEWS("vtkViewsJava"),
    VOLUME_RENDERING("vtkVolumeRenderingJava"),
    WIDGETS("vtkWidgetsJava"),
    CHARTS("vtkChartsJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean bl = true;
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
            try {
                vtkNativeLibrary2.LoadLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
            }
        }
        return bl;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... vtkNativeLibraryArray) {
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibraryArray) {
            vtkNativeLibrary2.LoadLibrary();
        }
    }

    public static void DisableOutputWindow(File file) {
        if (file == null) {
            file = new File("vtkError.txt");
        }
        vtkFileOutputWindow vtkFileOutputWindow2 = new vtkFileOutputWindow();
        vtkFileOutputWindow2.SetFileName(file.getAbsolutePath());
        vtkFileOutputWindow2.SetInstance(vtkFileOutputWindow2);
    }

    private vtkNativeLibrary(String string2) {
        this.nativeLibraryName = string2;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File file = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(file.getAbsolutePath());
                File file2 = new File(file, System.mapLibraryName(this.nativeLibraryName));
                if (file2.exists()) {
                    try {
                        Runtime.getRuntime().load(file2.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String string) {
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            String string3 = System.getProperty("java.library.path");
            if (!string3.contains(string)) {
                string3 = string3 + string2 + string;
                System.setProperty("java.library.path", string3);
            }
        }
    }
}

