/*
 * Decompiled with CFR 0.152.
 */
package org.keridwen.vtk.service.windows;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.keridwen.vtk.service.VtkReadyService;
import org.slf4j.LoggerFactory;

public class WinVtkReadyService
implements VtkReadyService,
Pojo {
    private InstanceManager __IM;
    private static boolean vtkReady = false;
    private boolean __Mstop;
    private boolean __MisVtkReady;
    private boolean __MloadVTKJava;

    public WinVtkReadyService() {
        this(null);
    }

    private WinVtkReadyService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public final void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        vtkReady = false;
    }

    public boolean isVtkReady() {
        boolean bl;
        if (!this.__MisVtkReady) {
            return this.__isVtkReady();
        }
        try {
            this.__IM.onEntry((Object)this, "isVtkReady", new Object[0]);
            bl = this.__isVtkReady();
            this.__IM.onExit((Object)this, "isVtkReady", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isVtkReady", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isVtkReady() {
        return vtkReady;
    }

    public boolean loadVTKJava() {
        boolean bl;
        if (!this.__MloadVTKJava) {
            return this.__loadVTKJava();
        }
        try {
            this.__IM.onEntry((Object)this, "loadVTKJava", new Object[0]);
            bl = this.__loadVTKJava();
            this.__IM.onExit((Object)this, "loadVTKJava", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadVTKJava", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __loadVTKJava() {
        System.loadLibrary("vtkCommonJava");
        System.loadLibrary("vtkFilteringJava");
        System.loadLibrary("vtkIOJava");
        System.loadLibrary("vtkImagingJava");
        System.loadLibrary("vtkGraphicsJava");
        System.loadLibrary("vtkRenderingJava");
        try {
            System.loadLibrary("vtkHybridJava");
        }
        catch (Throwable e) {
            System.out.println("cannot load vtkHybrid, skipping...");
        }
        try {
            System.loadLibrary("vtkVolumeRenderingJava");
        }
        catch (Throwable e) {
            System.out.println("cannot load vtkVolumeRendering, skipping...");
        }
        return true;
    }

    static {
        try {
            System.loadLibrary("awt");
            System.loadLibrary("jawt");
            System.loadLibrary("msvcr100");
            System.loadLibrary("msvcp100");
            System.loadLibrary("vtkproj4");
            System.loadLibrary("vtkalglib");
            System.loadLibrary("vtksys");
            System.loadLibrary("vtkCommon");
            System.loadLibrary("vtkFiltering");
            System.loadLibrary("vtkexpat");
            System.loadLibrary("vtkjpeg");
            System.loadLibrary("vtkzlib");
            System.loadLibrary("vtklibxml2");
            System.loadLibrary("vtktiff");
            System.loadLibrary("vtkpng");
            System.loadLibrary("vtkmetaio");
            System.loadLibrary("vtkNetCDF");
            System.loadLibrary("vtkDICOMParser");
            System.loadLibrary("vtkNetCDF_cxx");
            System.loadLibrary("vtkIO");
            System.loadLibrary("vtkImaging");
            System.loadLibrary("vtkverdict");
            System.loadLibrary("vtkGraphics");
            System.loadLibrary("vtkfreetype");
            System.loadLibrary("vtkftgl");
            System.loadLibrary("vtkGenericFiltering");
            System.loadLibrary("vtkRendering");
            System.loadLibrary("vtkexoIIc");
            System.loadLibrary("Cosmo");
            System.loadLibrary("VPIC");
            System.loadLibrary("vtkParallel");
            System.loadLibrary("vtkHybrid");
            System.loadLibrary("vtkWidgets");
            System.loadLibrary("vtkVolumeRendering");
            vtkReady = true;
        }
        catch (UnsatisfiedLinkError e) {
            LoggerFactory.getLogger((String)WinVtkReadyService.class.getName()).error("VTK platform-specific bundle not loaded. 3D views and VTK export will not be available.");
            LoggerFactory.getLogger((String)WinVtkReadyService.class.getName()).debug("Error loading native libraries", (Throwable)e);
            vtkReady = false;
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("isVtkReady")) {
                this.__MisVtkReady = true;
            }
            if (set.contains("loadVTKJava")) {
                this.__MloadVTKJava = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

