package org.test.vtk.osgi;

import java.awt.BorderLayout;

import javax.swing.JFrame;

import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkPanel;
import vtk.vtkPolyDataMapper;

public class TestVTK extends JFrame {
    /**
     * Generated serial version ID.
     */
    private static final long serialVersionUID = 583121573661146371L;

    /**
     * Default constructor.
     */
    public TestVTK() {
	super();
    }
    
    /**
     * Start callback.
     * This method will be called when the instance becomes valid.
     * It sets the Gui visibility to true.
     */
    public void start() {
        // Build the VTK 3D view
	// (Should be done before using any vtk
        //  object or load the native
        //  library first)
        vtkPanel panel3D = new vtkPanel();

        // Build a simple VTK pipeline
        vtkConeSource coneSource = new vtkConeSource();
        coneSource.SetRadius(2);
        coneSource.SetAngle(15);
        coneSource.SetHeight(2);
        coneSource.SetResolution(10);

        vtkPolyDataMapper coneMapper = new vtkPolyDataMapper();
        coneMapper.SetInput(coneSource.GetOutput());

        vtkActor coneActor = new vtkActor();
        coneActor.SetMapper(coneMapper);

        // Add actor in 3D Panel
        panel3D.GetRenderer().AddActor(coneActor);
	
	System.out.println("Starting bundle");
	this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
	this.getContentPane().setLayout(new BorderLayout());
	this.getContentPane().add(panel3D, BorderLayout.CENTER);
	this.setSize(500, 500);
	this.setLocationRelativeTo(null); // Center on desktop
	this.setVisible(true);
    }

    /**
     * Stop callback.
     *  This method will be called when the instance becomes invalid or stops.
     *  It deletes the Gui.
     */
    public void stop() {
	System.out.println("Stopping bundle");
	this.dispose();
    }

}
