/* Medium Level TDC V1190 Driver - Original driver from JFC@IPN-CNRS for the V767 - MG xx/08/2005 @ LIXAM-CNRS*/
/* xx/02/2006 : Improvement of called functions for higher level programming */

#include "tdc1190_driver_low.h"

/*===================================================== DEFINES =================================================== */
#define NO_TDC_ERROR               0
#define TDC_ERROR                  0x0A<<16

#define MICRO_MAX_OPERAND          42
/* =============================================================================================================== */
/* STRUCTURES */
typedef struct {
  unsigned int command;
  char object;
  char nW;
  char nR;
  unsigned int nbit;
  unsigned int operand[MICRO_MAX_OPERAND];
} opcode;

/* ================================================================================================================ */
/* EXTERNAL PROTOTYPES */
/*---------------------- ACCESS TO REGISTER AND MICRO CONTROLLER ------------------------- */
int write_register(vme_access *tdc_access, int reg, unsigned int data);
int read_register(vme_access *tdc_access, int reg, unsigned int *data);
/*-----------------------------*/
int status_micro(vme_access *tdc_access, unsigned int *status );
int write_micro(vme_access *tdc_access, opcode *op);
int read_micro(vme_access *tdc_access, opcode *op);

/*--------------- ACCESS TO SPECIAL REGISTER : STATUS AND OUTPUT REGISTERS --------------- */
int read_status(vme_access *tdc_access, unsigned int *status);
/*----------------------------*/
int read_output(vme_access *tdc_access, long *out);
int read_MMAPoutput(vme_access *tdc_access, long *out);
/*----------------------------*/
void convert_output(unsigned int value, long *out);
void print_output(long *out);
