#include <stdio.h>
#include <stdlib.h>
#include "header.h"
#include "universe_io.h"
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "bits.h"

/* ------------------------------------------------------------------------
 --------------------------------- Main ---------------------------------
 ------------------------------------------------------------------------  */
int main(int argc,char **argv)
{
  int fd,res;
  unsigned short int data;
  struct vme_access_slsi loc;

  if (argc != 2)
    {
      printf("usage : %s device\n",argv[0]);
      exit(1);
    }
 /* ----------------------------------- Ouverture Driver */
  fd = open(argv[1],O_RDWR);
  if (fd == -1)
    {
      printf("%s isn't a valid device\n",argv[1]);
      exit(1);
    }

/*   --------------------------------- Lecture Firmware */
  loc.offset=TDC_BASE+FIRMWARE_VERSION;
  loc.valeur=0x00000000;
  loc.region=REGION0;
  res=ioctl(fd,UNIVERSE_READ24,&loc);
  if (res==-1) 
     {
      printf("erreur ioctl 0x%08x\n",(int)loc.erreur);
     }   	  
  else {
  	data=loc.valeur;
  	printf ("Firmware %08x\n",(int)data); 
        }
return 0;
}
