/* Common utilities - MG xx/xx/2006 @ LIXAM-CNRS*/


/* ============================================================================================================================ */
/* INCLUDES */
#include <unistd.h>
#include <termios.h>
#include <sys/time.h>
#include <sys/ioctl.h>

#include "keyboard.h"

/* ============================================================================================================================ */
/* STRUCTURE */ 
static struct termios stored_settings;

/* ============================================================================================================================ */
/* LOCAL PROTOTYPE*/
static void setKeypress(void);
static void resetKeypress(void);


/* ============================================================================================================================ */
static void setKeypress(void)
{
  struct termios new_settings;
  struct timeval tv;
  tcgetattr(0,&stored_settings);
  
  new_settings = stored_settings;

  /* Disable canonical mode, and echo and set buffer size to 1 byte */
  new_settings.c_lflag &= (~ICANON);
  new_settings.c_lflag &= (~ECHO);
  new_settings.c_cc[VTIME] = 0;
  new_settings.c_cc[VMIN] = 1;
  
  tcsetattr(0,TCSANOW,&new_settings);
  /* a slight time delay is required for tight loops*/
  tv.tv_sec  = 0; 
  tv.tv_usec = 100; 
  select(1, NULL, NULL, NULL, &tv);  
  return;
}
/* ============================================================================================================================ */
static void resetKeypress(void)
{
  tcsetattr(0,TCSANOW,&stored_settings);
  return;
}

/* ============================================================================================================================ */
int Keypressed(void) 
{
  int c;
  setKeypress();
  ioctl(0, FIONREAD, &c);
  resetKeypress();
  return c;
}
