
/* High Level TDC V1190 Driver - MG xx/08/2005 @ LIXAM-CNRS*/
/* xx/02/2006 : Improvement of the structure tdc1190 to simplify the user access*/
/* xx/05/2006 : Add rtai and dma access */
/* xx/10/2006 : Improvement of the "overload": to avoid crashes there is no more dynamical memory */

#include "tdc1190_driver_medium.h"
/* ============================================================================================================================ */
/* DEFINE */
#define WORDCOUNT 10
#define DMA_SIZE  1024
#define DATAFIFO_SIZE DMA_SIZE*(WORDCOUNT+1)
/* ============================================================================================================================ */
/* STRUCTURES */

/* List of event */
typedef struct event{
  unsigned long eventNumber, anodeEvent, toolongEvent, timerEvent, goodEvent;
  unsigned long  dataCount,data[128];
} Tevent;

/*  Tdc structure */
typedef struct caen1190 {
  unsigned char NumberOfChannel; 

  unsigned int  CtrlReg;/* Registers */
  unsigned int  IrqLevel;
  unsigned int  IrqVector;
  unsigned int  GeoAddress;
  unsigned int  MCSTAddress;
  unsigned int  MCSTControl;
  unsigned int  AlmostFull;
  unsigned int  BLTEventNumber;
  unsigned int  TestReg;
  unsigned int  OutProg;
  unsigned int  Dummy32;
  unsigned int  Dummy16;

  char          Acquisition_Mode;/* Micro Controler */
  unsigned int  Trigger_Config[5];
  int           Measurement_Config;
  char          Measurement[50];
  unsigned int  Edge_Resolution;
  unsigned int  Width_Resolution;
  int           Event_MaxHit;
  char          Event_HeaderTrailer;
  int           Channel_DeadTime;
  int		Channel_Active[128];
  int		Channel_Offset[128];
  unsigned int  ErrorTypes;
  int           FifoSize;
  unsigned int  TimeOffset[2];
  
  vme_access    tdc_access; 

  int		RTAIcounter_access, RTAIdata_access; /*RTAI access and buffer */
  long          RTAIcounter, RTAIoffset;
  long		RTAIcounter_fifo[WORDCOUNT];
  unsigned long RTAIdata_fifo[DATAFIFO_SIZE];
  
  Tevent        DataList[DATAFIFO_SIZE];  /*Data event per event*/
  long          totalTrig, counterTrig, totalEvent, totalTimer, totalAnode, Tdc_Error, Hit_Error; 

} tdc1190;

/* ============================================================================================================================ */
/* EXTERNAL PROTOTYPES TO READ FROM THE MICRO CONTROLER */
int GetTdc_AcqMode(tdc1190 *a_tdc);
int GetTdc_TriggerConfig(tdc1190 *a_tdc);
int GetTdc_EventMaxHit(tdc1190 *a_tdc);
int GetTdc_EventHeaderTrailer(tdc1190 *a_tdc);
int GetTdc_MeasurementConfig(tdc1190 *a_tdc);
int GetTdc_MeasurementResolution(tdc1190 *a_tdc);
int GetTdc_ChannelsDeadTime(tdc1190 *a_tdc);
int GetTdc_ChannelsActive(tdc1190 *a_tdc);
int GetTdc_ChannelsOffset(tdc1190 *a_tdc);
int GetTdc_ErrorTypes(tdc1190 *a_tdc);
int GetTdc_FifoSize(tdc1190 *a_tdc);
int GetTdc_GlobalOffset(tdc1190 *a_tdc);

/* ============================================================================================================================ */
/* EXTERNAL PROTOTYPES TO WRITE TO THE MICRO CONTROLER */
int SetTdc_AcqMode(tdc1190 *a_tdc, int status);
int SetTdc_KeepToken(tdc1190 *a_tdc, int status);
int SetTdc_LoadConfig(tdc1190 *a_tdc, int status);
int SetTdc_SaveUserConfig(tdc1190 *a_tdc);
int SetTdc_AutoLoadConfig(tdc1190 *a_tdc, int status);
int SetTdc_Window(tdc1190 *a_tdc, unsigned int width, int offset);
int SetTdc_Margin(tdc1190 *a_tdc, unsigned int extrasearch, unsigned int reject);
int SetTdc_TriggerSubstraction(tdc1190 *a_tdc, int status);
int SetTdc_MeasurementConfig(tdc1190 *a_tdc, unsigned int edge);
int SetTdc_MeasurementResolution(tdc1190 *a_tdc, unsigned int edge, unsigned int width);
int SetTdc_EventMaxHit(tdc1190 *a_tdc, int NbHits);
int SetTdc_EventHeaderTrailer(tdc1190 *a_tdc, int status);
int SetTdc_ChannelsDeadTime(tdc1190 *a_tdc, int deadtime);
int SetTdc_ChannelsActive(tdc1190 *a_tdc, int status);
int SetTdc_ChannelNActive(tdc1190 *a_tdc, int NumChannel, int status);
int SetTdc_ChannelNOffset(tdc1190 *a_tdc, int NumChannel, unsigned int offset);
int SetTdc_ErrorMark(tdc1190 *a_tdc, int status);
int SetTdc_ErrorBypass(tdc1190 *a_tdc, int status);
int SetTdc_ErrorTypes(tdc1190 *a_tdc);
int SetTdc_FifoSize(tdc1190 *a_tdc, int size);
int SetTdc_GlobalOffset(tdc1190 *a_tdc, unsigned int coarse, unsigned int fine);
int SetTdc_TestMode(tdc1190 *a_tdc, unsigned int lsb_testword, unsigned int hsb_testword, int status);


/* ============================================================================================================================ */
/* EXTERNAL PROTOTYPES TO READ FROM TDC REGISTERS */
int GetTdc_Status(tdc1190 *a_tdc,unsigned int *value);
int GetTdc_Event(tdc1190 *a_tdc, unsigned int *value);
int GetTdc_EventCounter(tdc1190 *a_tdc, unsigned int *value);
int GetTdc_EventStored(tdc1190 *a_tdc, unsigned int *value);
int GetTdc_Firmware(tdc1190 *a_tdc,unsigned int *value);
int GetTdc_EventFIFO(tdc1190 *a_tdc,unsigned int *value);
int GetTdc_EventFIFO_Stored(tdc1190 *a_tdc,unsigned int *value);
int GetTdc_EventFIFO_Status(tdc1190 *a_tdc,unsigned int *value);
int GetTdc_Control(tdc1190 *a_tdc);
int GetTdc_InterruptLevel(tdc1190 *a_tdc);
int GetTdc_InterruptVector(tdc1190 *a_tdc);
int GetTdc_GEO_Address(tdc1190 *a_tdc);
int GetTdc_MCST_Address(tdc1190 *a_tdc);
int GetTdc_MCST_Control(tdc1190 *a_tdc);
int GetTdc_AllmostFull(tdc1190 *a_tdc);
int GetTdc_BLT_EventNumber(tdc1190 *a_tdc);
int GetTdc_TestReg(tdc1190 *a_tdc);
int GetTdc_OutProg_Control(tdc1190 *a_tdc);
int GetTdc_Dummy32(tdc1190 *a_tdc);
int GetTdc_Dummy16(tdc1190 *a_tdc);

/* ============================================================================================================================ */
/* EXTERNAL PROTOTYPES TO WRITE TO TDC REGISTERS */
int SetTdc_ModuleReset(tdc1190 *a_tdc);
int SetTdc_ClearRegister(tdc1190 *a_tdc);
int SetTdc_ClearEvent(tdc1190 *a_tdc);
int SetTdc_SoftTrigger(tdc1190 *a_tdc);
int SetTdc_Control(tdc1190 *a_tdc, unsigned int value);
int SetTdc_InterruptLevel(tdc1190 *a_tdc, unsigned int value);
int SetTdc_InterruptVector(tdc1190 *a_tdc, unsigned int value);
int SetTdc_GEO_Address(tdc1190 *a_tdc, unsigned int value);
int SetTdc_MCST_Address(tdc1190 *a_tdc, unsigned int value);
int SetTdc_MCST_Control(tdc1190 *a_tdc, unsigned int value);
int SetTdc_AlmostFull(tdc1190 *a_tdc, unsigned int value);
int SetTdc_BLT_EventNumber(tdc1190 *a_tdc, unsigned int value);
int SetTdc_TestReg(tdc1190 *a_tdc, unsigned int value);
int SetTdc_OutProg_Control(tdc1190 *a_tdc, unsigned int value);
int SetTdc_Dummy32(tdc1190 *a_tdc, unsigned int value);
int SetTdc_Dummy16(tdc1190 *a_tdc, unsigned int value);

/* ============================================================================================================================ */
/* EXTERNAL PROTOTYPES TO ACCESS THE STRUCTURE */
int InitTdc(tdc1190 *a_tdc, unsigned int address, unsigned char NbChannel);
void PrintTdc_RegisterStatus(tdc1190 *a_tdc);
void PrintTdc_MicroStatus_1(tdc1190 *a_tdc);
void PrintTdc_MicroStatus_2(tdc1190 *a_tdc);
void PrintTdc_Status(tdc1190 *a_tdc);
char *Set2Bit(unsigned int value);

/* ============================================================================================================================ */
/* EXTERNAL PROTOTYPES FOR RTAI */
int startTdc_rtai(tdc1190 *a_tdc, unsigned int id, int size);
int readTdc_rtai(tdc1190 *a_tdc,int mode);
void stopTdc_rtai(tdc1190 *a_tdc);
void status_rtai(tdc1190 *a_tdc);
