/* Medium Level VME Driver from IPN-CNRS - MG xx/xx/2005 @ LIXAM -CNRS*/

#ifdef ON_BOARD
/* ============================================================================================================================ */
/* INCLUDES */
#include "universe_io.h"

/* ================================================================================ */
/* EXTERNAL DEFINE */
#define D16SP  REGION0
#define D32SP  REGION1
#define D16NPD REGION2
#define D32NPD REGION3
#endif
/* ================================================================================ */
/* EXTERNAL STRUCTURE */
typedef struct  {
  int fd;
  unsigned int address_device;
  unsigned int *mmap_address;
  size_t mmap_size;
} vme_access;

/* ================================================================================ */
/* EXTERNAL PROTOTYPES */
int open_vme(vme_access *vme, unsigned int address_device);
void close_vme(vme_access *vme);

/* ------------------------ Standart I/O on the VME -------------------------
   mode: A16, A24, A32
   region: for A16/A24 is "D16SP","D16NPD","D32SP","D32NPD", for A32 whatever
   address: is BASE_ADDRESS + OFFSET
   WATCH OUT: Only A24D16SP and A32D32 are tested */
int write_vme(vme_access *vme, int mode, int region, unsigned int offset, unsigned int data);
int read_vme(vme_access *vme, int mode, int region, unsigned int offset, unsigned int *data);


/* ----------------------- Memory Map Access -----------------------------
 mode : A16,A24,A32
 device_address: BASE_ADDRESS
 datatype: D8,D16,D32
 WATCH OUT: Only A32D32 is tested */
int init_mmap(vme_access *vme, int mode);
void close_mmap(vme_access *vme);
void write_mmap(vme_access *vme, unsigned int offset, int datatype,  unsigned int data);
unsigned int read_mmap(vme_access *vme, unsigned int offset, int datatype);

