/* Acquisition Loop with  TDC V1190 - MG xx/xx/2005 @ LIXAM-CNRS*/


/* ============================================================================================================================ */
/* INCLUDES */
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>

#include "tdc1190_driver_high.h"

/* ============================================================================================================================ */
/* DEFINE */
/*#define SOFT_TRIG*/
#define DMA_ON 
#define OFF 0
#define ON  1
/* ============================================================================================================================ */
int main (void)
{
  int i=0,ok=0;
  tdc1190 test;
  unsigned int out[5];
  unsigned int status=0;


  /* Init TDC*/
  InitTdc(&test,0x1220000,128);
 
  /*TDC Status : Set and Get*/
  printf("Init Module for acquisition...\n");
  SetTdc_EventMaxHit(&test,16);
  SetTdc_AcqMode(&test,1);
  SetTdc_TestMode(&test,0xbbaa,0x0007,ON);
  SetTdc_KeepToken(&test,ON);
  SetTdc_EventHeaderTrailer(&test, OFF);
  SetTdc_EdgeConfig(&test, 1);
  SetTdc_ErrorMark(&test,OFF);
  SetTdc_AlmostFull(&test,16367);
  PrintTdc_Status(&test);
 
  /*Send a Real trig to the unit */
  printf("Send Trigger & Read out ...\n");
  do
    {
      do /* Wait until it the buffer is 1/2 filled */
	{
#ifdef SOFT_TRIG
	  SetTdc_SoftTrigger(&test);sleep(1);
#endif
	  GetTdc_Status(&test, &status);
	  ok=status&2;
      } while(!ok);
      /* Read-out Buffer */ 
      i=0;  
      do  /* Empty 1/2 of the buffer */ 
	{
#ifdef DMA_ON
	  read_DMAoutput(&test.tdc_access, out);  /* Bench Mark with 16 hits <-> 13.6 kHz */
#else
	  read_output(&test.tdc_access, out);    /* Bench Mark with 16 hits <-> 3.6 kHz */
#endif 
	  /*print_output(out); */
	  i+=1;
	} while (i<16367);
      GetTdc_Status(&test, &status);
      ok=status&4;
    } while (!ok);
  printf("Module Full !!\n");  
  /* End */
  SetTdc_TestMode(&test,0xbbaa,0x00cc,OFF);
  close_vme(&test.tdc_access);
  return 0;
}
