#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include "universe_io.h"

#include "header.h"

int main(int argc,char **argv)
{
  int fd;
  struct vme_access_lsi data;
  int res;
  size_t length=16*1024;
  unsigned int *ptr_mmap,*ptr_mmap_offset;

  fd = open("/dev/universe",O_RDWR);
  if (fd == -1)
    {
      printf("erreur ouverture device\n");
      exit(1);
    }

  data.offset = TDC_BASE + DUMMY32;
  data.valeur = 0xaddacaca;
  data.erreur = 0;
  data.lsi = 0;
  res = ioctl(fd,UNIVERSE_WRITE_LSI,&data);
  if (res != 0)
    {
      printf("read error %lx\n",data.erreur);
    }
  else
    {
      printf("write value %lx\n",data.valeur);
    }
  res = ioctl(fd,UNIVERSE_MMAP_SET_REGION_PCI_VME,0|LSI_MMAP); /* 0 pour l'image lsi 0 : a32d32*/
  ptr_mmap = (unsigned int *) mmap(NULL,length,PROT_READ|PROT_WRITE,MAP_SHARED,fd,TDC_BASE);
  if (ptr_mmap == MAP_FAILED)
    {
      printf("map failed argl...\n");
      exit(1);
    }
  ptr_mmap_offset = ptr_mmap + (int)(DUMMY32/4);
  printf("read value %lx\n",*ptr_mmap_offset);
  munmap(ptr_mmap,length);
  close(fd);
  return 0;
}
