/* Low Level TDC V1190 Driver - Original driver from JFC@IPN-CNRS for the V767 - MG xx/xx/2005 @ LIXAM-CNRS*/

/* ============================================================================================================================ */
/* INCLUDES */

#include <stdio.h>
#include <unistd.h>
#include "vme_driver.h"

/* =========================================== REGISTER ADDRESS MAP ============================================== */

#define OUTPUT_REGISTER				0x0000     /* 	A24/A32-D32-R	|BLT/CBLT			   */
#define CONTROL_REGISTER			0x1000	   /* 	A24/A32-D16-R/W 	|MSCT	|CLEAR ON WRITE	   */
#define STATUS_REGISTER				0x1002	   /* 	A24/A32-D16-R					   */
#define INTERRUPT_LEVEL				0x100A	   /* 	A24/A32-D16-R/W 	|MSCT			   */
#define INTERRUPT_VECTOR			0x100C	   /* 	A24/A32-D16-R/W 	|MSCT  			   */
#define GEO_ADDRESS_REGISTER		        0x100E	   /* 	A24/A32-D16-R/W			|CLEAR ON WRITE	   */
#define MCST_BASE_ADDRESS			0x1010	   /* 	A24/A32-D16-R/W			|CLEAR ON WRITE	   */
#define MCST_CONTROL				0x1012	   /* 	A24/A32-D16-R/W			|CLEAR ON WRITE	   */
#define MODULE_RESET				0x1014	   /* 	A24/A32-D16-W 		|MSCT			   */
#define SOFTWARE_CLEAR				0x1016	   /* 	A24/A32-D16-W 		|MSCT			   */
#define SOFTWARE_EVENT_RESET		        0x1018	   /* 	A24/A32-D16-W 		|MSCT			   */
#define SOFTWARE_TRIGGER			0x101A	   /* 	A24/A32-D16-W 		|MSCT			   */
#define EVENT_COUNTER				0x101C	   /* 	A24/A32-D32-R					   */
#define EVENT_STORED				0x1020	   /* 	A24/A32-D16-R				     	   */
#define ALMOST_FULL_EVENT			0x1022	   /* 	A24/A32-D16-R/W 	|MSCT	|CLEAR ON WRITE	   */
#define BTL_EVENT_NUMBER			0x1024	   /* 	A24/A32-D16-R/W 	|MSCT			   */
#define FIRMWARE_VERSION			0x1026	   /* 	A24/A32-D16-R					   */
#define TEST_REG				0x1028	   /* 	A24/A32-D32-R/W 	|MSCT			   */
#define OUTPUT_PROG_CONTROL			0x102C	   /* 	A24/A32-D16-R/W 	|MSCT			   */
#define MICRO					0x102E	   /* 	A24/A32-D16-R/W 	|MSCT			   */
#define MICRO_HANDSHAKE				0x1030	   /* 	A24/A32-D16-R					   */
#define SELECT_FLASH				0x1032	   /* 	A24/A32-D16-R/W					   */
#define FLASH_MEMORY				0x1034	   /* 	A24/A32-D16-R/W					   */
#define SRAM_PAGE				0x1036	   /* 	A24/A32-D16-R/W					   */
#define EVENT_FIFO				0x1038	   /* 	A24/A32-D32-R					   */
#define EVENT_FIFO_STORED			0x103C	   /* 	A24/A32-D16-R					   */
#define EVENT_FIFO_STATUS			0x103E	   /* 	A24/A32-D16-R	 	|MSCT			   */
#define DUMMY32					0x1200	   /* 	A24/A32-D32-R/W	 	|MSCT			   */
#define DUMMY16					0x1204	   /* 	A24/A32-D16-R/W			                   */
#define CONFIGURATION_ROM			0x4000	   /* 	A24/A32-A24/A32-R				   */
#define CONFIGURATION_SRAM			0x8000	   /* 	A24/A32-A24/A32-R				   */

/* ============================================ MICRO CONTROL OPCODE ============================================= */
#define TRG_MATCH					0x00 /* ACQUISITION MODE */
#define CONT_STOR					0x01
#define READ_ACQ_MOD					0x02
#define SET_KEEP_TOKEN					0x03
#define CLEAR_KEEP_TOKEN				0x04
#define LOAD_DEF_CONFIG					0x05
#define SAVE_USER_CONFIG				0x06
#define LOAD_USER_CONFIG				0x07
#define AUTOLOAD_USER_CONF				0x08
#define AUTOLOAD_DEF_CONF				0x09
#define SET_WIN_WIDTH					0x10 /* TRIGGER */
#define SET_WIN_OFFS					0x11
#define SET_SW_MARGIN					0x12
#define SET_REJ_MARGIN					0x13
#define EN_SUB_TRG					0x14
#define DIS_SUB_TRG					0x15
#define READ_TRG_CONF					0x16
#define SET_DETECTION					0x22 /* TDC EDGE DETECTION AND RESOLUTION */
#define READ_DETECTION					0x23
#define SET_TR_LEAD_LSB					0x24
#define SET_PAIR_RES					0x25
#define READ_RES					0x26
#define SET_DEAD_TIME					0x28
#define READ_DEAD_TIME					0x29
#define EN_HEAD_TRAILER					0x30 /* TDC READOUT */
#define DIS_HEAD_TRAILER				0x31
#define READ_HEAD_TRAILER				0x32
#define SET_EVENT_SIZE					0x33
#define READ_EVENT_SIZE					0x34
#define EN_ERROR_MARK					0x35
#define DIS_ERROR_MARK					0x36
#define EN_ERROR_BYPASS					0x37
#define DIS_ERROR_BYPASS				0x38
#define SET_ERROR_TYPES					0x39
#define READ_ERROR_TYPES				0x3A
#define SET_FIFO_SIZE					0x3B
#define READ_FIFO_SIZE					0x3C
#define EN_CHANNEL					0x40 /* CHANNEL ENABLE */
#define DIS_CHANNEL					0x41
#define EN_ALL_CH					0x42
#define DIS_ALL_CH					0x43
#define WRITE_EN_PATTERN				0x44
#define READ_EN_PATTERN					0x45
#define WRITE_EN_PATTERN32				0x46
#define READ_EN_PATTERN32				0x47
#define SET_GLOB_OFFS					0x50 /* ADJUST */
#define READ_GLOB_OFFS					0x51
#define SET_ADJUST_CH					0x52
#define READ_ADJUST_CH					0x53
#define SET_RC_ADJ					0x54
#define READ_RC_ADJ					0x55
#define SAVE_RC_ADJ					0x56
#define READ_TDC_ID					0x60 /* MISCELLANEOUS */
#define READ_MICRO_REV					0x61
#define RESET_DLL_PLL					0x62
#define WRITE_SETUP_REG					0x70 /* ADVANCED */
#define READ_SETUP_REG					0x71
#define UPDATE_SETUP_REG				0x72
#define DEFAULT_SETUP_REG				0x73
#define READ_ERROR_STATUS				0x74
#define READ_DLL_LOCK					0x75
#define READ_STATUS_STREAM				0x76
#define WRITE_EEPROM					0xC0 /* DEBUG AND TEST */
#define READ_EEPROM					0xC1
#define REVISION_DATE_MICRO_FIRMWARE	                0xC2
#define WRITE_SPARE					0xC3
#define READ_SPARE					0xC4
#define ENABLE_TEST_MODE				0xC5
#define DISABLE_TEST_MODE				0xC6
#define SET_TDC_TEST_OUTPUT				0xC7
#define SET_DLL_CLOCK					0xC8
#define READ_TDC_SETUP_SCAN_PATH		        0xC9
