/*
 * (c) Copyright: Artenum SARL, 24 rue Louis Blanc,
 *                75010, Paris, France 2007.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 24 rue Louis Blanc,
 *    75010, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.rosetta.ui;

import java.awt.BorderLayout;

import javax.swing.JComponent;
import javax.swing.JPanel;

import com.artenum.rosetta.interfaces.ui.CommandLineView;
import com.artenum.rosetta.interfaces.ui.OutputView;

/**
 * @author Sebastien Jourdain (jourdain@artenum.com)
 */
public class CommandLineViewImpl extends JPanel implements CommandLineView {
	private static final long serialVersionUID = 1L;

	public CommandLineViewImpl() {
		setLayout(new BorderLayout());
		setMinimumSize(OutputView.SMALL);
	}

	public void setInputCommandView(JComponent command) {
		add(command, BorderLayout.CENTER);
	}

	public void setPromptView(JComponent prompt) {
		add(prompt, BorderLayout.WEST);
	}

	public void setVisible(boolean visible) {
		if (visible) {
			expand();
		} else {
			shrink();
		}
	}

	private void shrink() {
		setMaximumSize(OutputView.SMALL);
		invalidate();
		doLayout();
	}

	private void expand() {
		setMaximumSize(OutputView.BIG);
		invalidate();
		doLayout();
	}

}
