/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.util.CassandraToolBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import vtk.vtkTextActor;

public class TxtActorControlDialog
extends JDialog {
    private PipeLineManager pipelineManager;
    private VtkObject currentVtkObject;
    private JTextField txtContent;
    private JFormattedTextField posX;
    private JFormattedTextField posY;
    private JFormattedTextField fontSize;
    private JButton color;
    private JButton exit;
    private JButton update;

    public TxtActorControlDialog(final Frame frame, final PipeLineManager pipeLineManager) {
        super(frame, "Text control");
        this.pipelineManager = pipeLineManager;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Text content"));
        this.txtContent = new JTextField();
        jPanel.add((Component)this.txtContent, "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Range"));
        JPanel jPanel2 = new JPanel(new GridLayout(4, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(4, 0));
        this.posX = new JFormattedTextField((Object)"0");
        this.posX.setValue(new Double(0.0));
        this.posX.setColumns(20);
        this.posY = new JFormattedTextField((Object)"0");
        this.posY.setValue(new Double(0.0));
        this.fontSize = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.color = new JButton();
        this.color.setBackground(Color.WHITE);
        jPanel2.add(new JLabel("X : ", 4));
        jPanel2.add(new JLabel("Y : ", 4));
        jPanel2.add(new JLabel("Font size : ", 4));
        jPanel2.add(new JLabel("Color : ", 4));
        jPanel3.add(this.posX);
        jPanel3.add(this.posY);
        jPanel3.add(this.fontSize);
        jPanel3.add(this.color);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        this.getContentPane().add(jPanel);
        this.color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                vtkTextActor vtkTextActor2 = (vtkTextActor)TxtActorControlDialog.this.currentVtkObject.getVtkObject();
                Color color = JColorChooser.showDialog(frame, "Text color", CassandraToolBox.vtkColorConverter(vtkTextActor2.GetTextProperty().GetColor()));
                if (color != null) {
                    TxtActorControlDialog.this.color.setBackground(color);
                    vtkTextActor2.GetTextProperty().SetColor(CassandraToolBox.vtkColorConverter(color));
                }
                pipeLineManager.validateView();
            }
        });
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = ((Number)TxtActorControlDialog.this.posX.getValue()).doubleValue();
                double d2 = ((Number)TxtActorControlDialog.this.posY.getValue()).doubleValue();
                int n = ((Number)TxtActorControlDialog.this.fontSize.getValue()).intValue();
                vtkTextActor vtkTextActor2 = (vtkTextActor)TxtActorControlDialog.this.currentVtkObject.getVtkObject();
                vtkTextActor2.SetPosition(d, d2);
                vtkTextActor2.SetInput(TxtActorControlDialog.this.txtContent.getText());
                vtkTextActor2.GetTextProperty().SetFontSize(n);
                pipeLineManager.validateView();
            }
        });
        this.exit = new JButton("Cancel");
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TxtActorControlDialog.this.dispose();
            }
        });
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.update);
        jPanel.add(this.exit);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void setTxtActor(VtkObject vtkObject) {
        this.currentVtkObject = vtkObject;
        vtkTextActor vtkTextActor2 = (vtkTextActor)this.currentVtkObject.getVtkObject();
        this.posX.setValue(new Double(vtkTextActor2.GetPosition()[0]));
        this.posY.setValue(new Double(vtkTextActor2.GetPosition()[1]));
        this.fontSize.setValue(new Integer(vtkTextActor2.GetTextProperty().GetFontSize()));
        this.txtContent.setText(vtkTextActor2.GetInput());
    }
}

