/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.ui.dialog.ScalarBarControlDialog;
import com.artenum.cassandra.ui.popup.ActorPopupMenu;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.CassandraToolBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkLookupTable;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ScalarBarPopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String SCALAR_BAR_REMOVE = "scalar.bar.remove";
    public static final String SCALAR_BAR_CONTROL = "scalar.bar.control";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private VtkObject currentVtkObject;
    private Hashtable controlDialogTable;
    private ActorPopupMenu actorMenu;
    private JMenuItem showControl;
    private RenameVtkObject scalarBarRename;
    private JMenuItem scalarBarRemove;
    private JMenu lookupTableList;

    public ScalarBarPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.controlDialogTable = new Hashtable();
        this.actorMenu = new ActorPopupMenu(pipeLineManager, cascadeRemoveManager);
        this.add(this.actorMenu.getActorVisibleMenuItem());
        this.add(this.actorMenu.getActorOpacityMenuItem());
        this.addSeparator();
        this.showControl = new JMenuItem("Show control");
        this.showControl.setActionCommand(SCALAR_BAR_CONTROL);
        this.showControl.addActionListener(this);
        this.add(this.showControl);
        this.lookupTableList = new JMenu("Link to lookup table...");
        this.add(this.lookupTableList);
        this.scalarBarRename = new RenameVtkObject("Rename", "Rename scalar bar", null);
        this.add(this.scalarBarRename);
        this.addSeparator();
        this.scalarBarRemove = new JMenuItem("Remove");
        this.scalarBarRemove.setActionCommand(SCALAR_BAR_REMOVE);
        this.scalarBarRemove.addActionListener(this);
        this.add(this.scalarBarRemove);
    }

    public void setCurrentVtkOject(VtkObject vtkObject) {
        this.currentVtkObject = vtkObject;
        this.scalarBarRename.setVtkObject(vtkObject);
        this.updateLookupTableList();
        this.actorMenu.setCurrentVtkOject(vtkObject);
        if (this.controlDialogTable.get(vtkObject) != null) {
            ((ScalarBarControlDialog)this.controlDialogTable.get(vtkObject)).setScalarBar(vtkObject);
        }
    }

    private void updateLookupTableList() {
        VtkObject vtkObject = null;
        this.lookupTableList.removeAll();
        JMenuItem jMenuItem = null;
        Iterator iterator = this.pipeLineManager.getLookupTableList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            jMenuItem = new JMenuItem(vtkObject.getName());
            jMenuItem.addActionListener(new LookupTableSetter((vtkLookupTable)vtkObject.getVtkObject()));
            this.lookupTableList.add(jMenuItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SCALAR_BAR_REMOVE)) {
            this.cascadeRemoveManager.removeScalarBar(this.currentVtkObject);
        } else if (string.equals(SCALAR_BAR_CONTROL)) {
            ((ScalarBarControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setVisible(true);
        }
    }

    public void show(Component component, int n, int n2) {
        if ((ScalarBarControlDialog)this.controlDialogTable.get(this.currentVtkObject) == null) {
            this.controlDialogTable.put(this.currentVtkObject, new ScalarBarControlDialog(CassandraToolBox.getParentFrame(component), this.pipeLineManager));
            ((ScalarBarControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setScalarBar(this.currentVtkObject);
        }
        super.show(component, n, n2);
    }

    private class LookupTableSetter
    implements ActionListener {
        private vtkLookupTable lookupTable;

        public LookupTableSetter(vtkLookupTable vtkLookupTable2) {
            this.lookupTable = vtkLookupTable2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((vtkScalarBarActor)ScalarBarPopupMenu.this.currentVtkObject.getVtkObject()).SetLookupTable((vtkScalarsToColors)this.lookupTable);
            ScalarBarPopupMenu.this.pipeLineManager.notifyConnectivityChange(ScalarBarPopupMenu.this.currentVtkObject);
            ScalarBarPopupMenu.this.pipeLineManager.validateView();
        }
    }
}

