/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cutter;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.cutter.CutterPlugin;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import vtk.vtkDataSet;

public class CutterControlUI
extends JDialog
implements ActionListener,
ChangeListener {
    private PipeLineManager pipeLineManager;
    private JComboBox input;
    private JTabbedPane tab;
    private JFormattedTextField planeCenterX;
    private JFormattedTextField planeCenterY;
    private JFormattedTextField planeCenterZ;
    private JFormattedTextField planeNormalX;
    private JFormattedTextField planeNormalY;
    private JFormattedTextField planeNormalZ;
    private JSlider planeSlider;
    private JFormattedTextField sphereCenterX;
    private JFormattedTextField sphereCenterY;
    private JFormattedTextField sphereCenterZ;
    private JFormattedTextField sphereRadius;
    private JFormattedTextField cylinderCenterX;
    private JFormattedTextField cylinderCenterY;
    private JFormattedTextField cylinderCenterZ;
    private JFormattedTextField cylinderRx;
    private JFormattedTextField cylinderRy;
    private JFormattedTextField cylinderRz;
    private JFormattedTextField cylinderRadius;
    private CutterPlugin plugin;

    public CutterControlUI(PipeLineManager pipeLineManager, CutterPlugin cutterPlugin, Frame frame) {
        super(frame, "Cutting plane configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = cutterPlugin;
        this.input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(new JLabel("Input Dataset"));
        jPanel.add(this.input);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        this.planeCenterX = new JFormattedTextField((Object)"0");
        this.planeCenterX.setValue(new Double(0.0));
        this.planeCenterY = new JFormattedTextField((Object)"0");
        this.planeCenterY.setValue(new Double(0.0));
        this.planeCenterZ = new JFormattedTextField((Object)"0");
        this.planeCenterZ.setValue(new Double(0.0));
        this.planeNormalX = new JFormattedTextField((Object)"0");
        this.planeNormalX.setValue(new Double(0.0));
        this.planeNormalY = new JFormattedTextField((Object)"0");
        this.planeNormalY.setValue(new Double(0.0));
        this.planeNormalZ = new JFormattedTextField((Object)"0");
        this.planeNormalZ.setValue(new Double(1.0));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 4));
        jPanel3.add(new JLabel());
        jPanel3.add(new JLabel("X"));
        jPanel3.add(new JLabel("Y"));
        jPanel3.add(new JLabel("Z"));
        jPanel3.add(new JLabel("Center"));
        jPanel3.add(this.planeCenterX);
        jPanel3.add(this.planeCenterY);
        jPanel3.add(this.planeCenterZ);
        jPanel3.add(new JLabel("Normal"));
        jPanel3.add(this.planeNormalX);
        jPanel3.add(this.planeNormalY);
        jPanel3.add(this.planeNormalZ);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(-10), new JLabel("-1"));
        hashtable.put(new Integer(10), new JLabel("1"));
        hashtable.put(new Integer(0), new JLabel("0"));
        this.planeSlider = new JSlider(-10, 10, 0);
        this.planeSlider.setMinorTickSpacing(1);
        this.planeSlider.setMajorTickSpacing(10);
        this.planeSlider.setLabelTable(hashtable);
        this.planeSlider.setPaintLabels(true);
        this.planeSlider.setPaintLabels(true);
        this.planeSlider.addChangeListener(this);
        this.planeSlider.setToolTipText("Translation based on center point with the normal vector has unit");
        jPanel2.add(jPanel3);
        jPanel2.add(this.planeSlider);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        this.sphereCenterX = new JFormattedTextField((Object)"0");
        this.sphereCenterX.setValue(new Double(0.0));
        this.sphereCenterY = new JFormattedTextField((Object)"0");
        this.sphereCenterY.setValue(new Double(0.0));
        this.sphereCenterZ = new JFormattedTextField((Object)"0");
        this.sphereCenterZ.setValue(new Double(0.0));
        this.sphereRadius = new JFormattedTextField((Object)"0");
        this.sphereRadius.setValue(new Double(1.0));
        jPanel3 = new JPanel(new GridLayout(3, 4));
        jPanel3.add(new JLabel());
        jPanel3.add(new JLabel("X"));
        jPanel3.add(new JLabel("Y"));
        jPanel3.add(new JLabel("Z"));
        jPanel3.add(new JLabel("Center"));
        jPanel3.add(this.sphereCenterX);
        jPanel3.add(this.sphereCenterY);
        jPanel3.add(this.sphereCenterZ);
        jPanel3.add(new JLabel("Radius"));
        jPanel3.add(this.sphereRadius);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 3));
        this.cylinderCenterX = new JFormattedTextField((Object)"0");
        this.cylinderCenterX.setValue(new Double(0.0));
        this.cylinderCenterY = new JFormattedTextField((Object)"0");
        this.cylinderCenterY.setValue(new Double(0.0));
        this.cylinderCenterZ = new JFormattedTextField((Object)"0");
        this.cylinderCenterZ.setValue(new Double(0.0));
        this.cylinderRx = new JFormattedTextField((Object)"0");
        this.cylinderRx.setValue(new Double(0.0));
        this.cylinderRy = new JFormattedTextField((Object)"0");
        this.cylinderRy.setValue(new Double(0.0));
        this.cylinderRz = new JFormattedTextField((Object)"0");
        this.cylinderRz.setValue(new Double(0.0));
        this.cylinderRadius = new JFormattedTextField((Object)"0");
        this.cylinderRadius.setValue(new Double(1.0));
        jPanel3 = new JPanel(new GridLayout(3, 4));
        jPanel3.add(new JLabel());
        jPanel3.add(new JLabel("X"));
        jPanel3.add(new JLabel("Y"));
        jPanel3.add(new JLabel("Z"));
        jPanel3.add(new JLabel("Center"));
        jPanel3.add(this.cylinderCenterX);
        jPanel3.add(this.cylinderCenterY);
        jPanel3.add(this.cylinderCenterZ);
        jPanel3.add(new JLabel("Rotate"));
        jPanel3.add(this.cylinderRx);
        jPanel3.add(this.cylinderRy);
        jPanel3.add(this.cylinderRz);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 2));
        jPanel6.add(new JLabel("Radius"));
        jPanel6.add(this.cylinderRadius);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel6);
        JButton jButton = new JButton("Update");
        jButton.setActionCommand("UPDATE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 2));
        jPanel7.add(Box.createHorizontalGlue());
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        this.tab = new JTabbedPane();
        this.tab.add("Plane", jPanel2);
        this.tab.add("Sphere", jPanel4);
        this.tab.add("Cylinder", jPanel5);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(this.tab);
        this.getContentPane().add(jPanel7);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.setSize(dimension.getWidth() + 100.0, dimension.getHeight());
        this.setSize(dimension);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("UPDATE")) {
            if (this.input.getSelectedItem() == null) {
                return;
            }
            switch (this.tab.getSelectedIndex()) {
                case 0: {
                    this.planeSlider.setValue(0);
                    this.plugin.updateCuttingPlane(((Number)this.planeCenterX.getValue()).doubleValue(), ((Number)this.planeCenterY.getValue()).doubleValue(), ((Number)this.planeCenterZ.getValue()).doubleValue(), ((Number)this.planeNormalX.getValue()).doubleValue(), ((Number)this.planeNormalY.getValue()).doubleValue(), ((Number)this.planeNormalZ.getValue()).doubleValue(), (vtkDataSet)((VtkObject)this.input.getSelectedItem()).getVtkObject());
                    break;
                }
                case 1: {
                    this.plugin.updateCuttingSphere(((Number)this.sphereCenterX.getValue()).doubleValue(), ((Number)this.sphereCenterY.getValue()).doubleValue(), ((Number)this.sphereCenterZ.getValue()).doubleValue(), ((Number)this.sphereRadius.getValue()).doubleValue(), (vtkDataSet)((VtkObject)this.input.getSelectedItem()).getVtkObject());
                    break;
                }
                case 2: {
                    this.plugin.updateCuttingCylinder(((Number)this.cylinderCenterX.getValue()).doubleValue(), ((Number)this.cylinderCenterY.getValue()).doubleValue(), ((Number)this.cylinderCenterZ.getValue()).doubleValue(), ((Number)this.cylinderRx.getValue()).doubleValue(), ((Number)this.cylinderRy.getValue()).doubleValue(), ((Number)this.cylinderRz.getValue()).doubleValue(), ((Number)this.cylinderRadius.getValue()).doubleValue(), (vtkDataSet)((VtkObject)this.input.getSelectedItem()).getVtkObject());
                    break;
                }
            }
        }
        if (string.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        double d = (double)this.planeSlider.getValue() / 10.0;
        double d2 = ((Number)this.planeNormalX.getValue()).doubleValue();
        double d3 = ((Number)this.planeNormalY.getValue()).doubleValue();
        double d4 = ((Number)this.planeNormalZ.getValue()).doubleValue();
        double d5 = ((Number)this.planeCenterX.getValue()).doubleValue();
        double d6 = ((Number)this.planeCenterY.getValue()).doubleValue();
        double d7 = ((Number)this.planeCenterZ.getValue()).doubleValue();
        if (this.input.getSelectedItem() != null) {
            this.plugin.updateCuttingPlane(d5 + d2 * d, d6 + d3 * d, d7 + d4 * d, d2, d3, d4, (vtkDataSet)((VtkObject)this.input.getSelectedItem()).getVtkObject());
        }
    }

    class DataSetListModel
    implements ComboBoxModel {
        private VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel vtkObjectListModel) {
            this.datasetModel = vtkObjectListModel;
        }

        public Object getElementAt(int n) {
            return this.datasetModel.getElementAt(n);
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public int getSize() {
            return this.datasetModel.getSize();
        }

        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.datasetModel.addListDataListener(listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.datasetModel.removeListDataListener(listDataListener);
        }
    }
}

