/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cutter;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.cutter.CutterControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkAbstractTransform;
import vtk.vtkActor;
import vtk.vtkBoxWidget;
import vtk.vtkCone;
import vtk.vtkCutter;
import vtk.vtkCylinder;
import vtk.vtkDataSet;
import vtk.vtkImplicitFunction;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkSphere;
import vtk.vtkTransform;

public class CutterPlugin
implements CassandraPlugin,
RemoveListener {
    private String name = "Generic Cutter";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private int nbUpdate = 0;
    private CutterControlUI controlUI;
    private vtkPlane plane;
    private vtkBoxWidget box;
    private vtkCylinder cylinder;
    private vtkCone cone;
    private vtkSphere sphere;
    private vtkTransform cylinderTransform;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkCutter cutter;
    private vtkPolyDataMapper cutMapper;
    private vtkActor cutActor;
    private Filter filerImpl;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject filter;

    public CutterPlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.filerImpl = new FilterImpl();
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.controlUI = new CutterControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("Generic Cutter");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CutterPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CutterPlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.plane = new vtkPlane();
        this.plane.SetOrigin(0.0, 0.0, 0.0);
        this.plane.SetNormal(0.0, 0.0, 1.0);
        this.cone = new vtkCone();
        this.cone.SetAngle(15.0);
        this.box = new vtkBoxWidget();
        this.sphere = new vtkSphere();
        this.sphere.SetCenter(0.0, 0.0, 0.0);
        this.sphere.SetRadius(10.0);
        this.cylinder = new vtkCylinder();
        this.cylinder.SetCenter(0.0, 0.0, 0.0);
        this.cylinder.SetRadius(10.0);
        this.cylinderTransform = new vtkTransform();
        this.cylinder.SetTransform((vtkAbstractTransform)this.cylinderTransform);
        this.cutter = new vtkCutter();
        this.cutter.SetCutFunction((vtkImplicitFunction)this.plane);
        this.cutMapper = new vtkPolyDataMapper();
        this.cutMapper.SetInput(this.cutter.GetOutput());
        this.cutActor = new vtkActor();
        this.cutActor.SetMapper((vtkMapper)this.cutMapper);
        try {
            this.lookupTable = new vtkLookupTable();
            this.lookupTable.SetHueRange(0.66667, 0.0);
            this.lookupTable.Build();
            this.cutMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        vtkScalarBarActor vtkScalarBarActor2 = null;
        try {
            vtkScalarBarActor2 = new vtkScalarBarActor();
            vtkScalarBarActor2.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.actor = pipeLineManager.addActor((Object)this.cutActor, "Cutter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mapper = pipeLineManager.addMapper((Object)this.cutMapper, "Cutter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataset = pipeLineManager.addDataSet((Object)this.cutter.GetOutput(), "Cutter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.filter = pipeLineManager.addFilter(this.filerImpl, "Cutter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pipeLineManager.addLookupTable(this.lookupTable, "Cutter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (vtkScalarBarActor2 != null) {
                pipeLineManager.setActorVisible(pipeLineManager.addScalarBar(vtkScalarBarActor2, "Cutter"), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateCuttingPlane(double d, double d2, double d3, double d4, double d5, double d6, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.plane.SetOrigin(d, d2, d3);
        this.plane.SetNormal(d4, d5, d6);
        this.cutter.SetCutFunction((vtkImplicitFunction)this.plane);
        this.cutter.SetInput(vtkDataSet2);
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filerImpl.getInputDataSet().clear();
        this.filerImpl.getInputDataSet().add(vtkDataSet2);
        this.filerImpl.getOutputDataSet().clear();
        this.filerImpl.getOutputDataSet().add(this.cutter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
        this.pipelineManager.validateView();
    }

    public void updateCuttingSphere(double d, double d2, double d3, double d4, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.sphere.SetCenter(d, d2, d3);
        this.sphere.SetRadius(d4);
        this.cutter.SetCutFunction((vtkImplicitFunction)this.sphere);
        this.cutter.SetInput(vtkDataSet2);
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filerImpl.getInputDataSet().clear();
        this.filerImpl.getInputDataSet().add(vtkDataSet2);
        this.filerImpl.getOutputDataSet().clear();
        this.filerImpl.getOutputDataSet().add(this.cutter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
        this.pipelineManager.validateView();
    }

    public void updateCuttingCylinder(double d, double d2, double d3, double d4, double d5, double d6, double d7, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.cylinder.SetCenter(d, d2, d3);
        this.cylinder.SetRadius(d7);
        this.cylinderTransform.RotateX(d4);
        this.cylinderTransform.RotateY(d5);
        this.cylinderTransform.RotateY(d6);
        this.cutter.SetCutFunction((vtkImplicitFunction)this.cylinder);
        this.cutter.SetInput(vtkDataSet2);
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filerImpl.getInputDataSet().clear();
        this.filerImpl.getInputDataSet().add(vtkDataSet2);
        this.filerImpl.getOutputDataSet().clear();
        this.filerImpl.getOutputDataSet().add(this.cutter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
        this.pipelineManager.validateView();
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }
}

