/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import java.util.Iterator;
import javax.swing.JOptionPane;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;

public class CascadeRemoveManager {
    private PipeLineManager pipelineManager;

    public CascadeRemoveManager(PipeLineManager pipeLineManager) {
        this.pipelineManager = pipeLineManager;
    }

    public void removeScalarBar(VtkObject vtkObject) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the scalar bar ?")) {
            this.removeActorWithOutQuestion(vtkObject);
        }
    }

    public void removeActor(VtkObject vtkObject) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the 3D actor ?")) {
            this.removeActorWithOutQuestion(vtkObject);
        }
    }

    public void removeLookupTable(VtkObject vtkObject) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the lookup table ?")) {
            this.removeLookupTableWithOutQuestion(vtkObject);
        }
    }

    public void removeFilter(VtkObject vtkObject) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the Filter ?")) {
            this.removeFilterWithOutQuestion(vtkObject);
        }
    }

    public void removeMapper(VtkObject vtkObject) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the Mapper ?")) {
            this.removeMapperWithOutQuestion(vtkObject);
        }
    }

    public void removeDataSet(VtkObject vtkObject) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the Dataset ?")) {
            this.removeDataSetWithOutQuestion(vtkObject);
        }
    }

    private void removeScalarBarWithOutQuestion(VtkObject vtkObject) {
        this.removeActorWithOutQuestion(vtkObject);
    }

    private void removeActorWithOutQuestion(VtkObject vtkObject) {
        this.pipelineManager.removeVtkObject(vtkObject);
    }

    private void removeLookupTableWithOutQuestion(VtkObject vtkObject) {
        Object[] objectArray = this.pipelineManager.getScalarBarList().getData().toArray();
        VtkObject vtkObject2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            vtkObject2 = (VtkObject)objectArray[i];
            if (!((vtkScalarBarActor)vtkObject2.getVtkObject()).GetLookupTable().equals(vtkObject.getVtkObject())) continue;
            this.removeActorWithOutQuestion(vtkObject2);
        }
        this.pipelineManager.removeVtkObject(vtkObject);
    }

    private void removeFilterWithOutQuestion(VtkObject vtkObject) {
        Filter filter = (Filter)vtkObject.getVtkObject();
        Object var3_3 = null;
        Iterator iterator = filter.getOutputActor().iterator();
        while (iterator.hasNext()) {
            this.removeActorWithOutQuestion(this.pipelineManager.getActorList().getVtkObject(iterator.next()));
        }
        iterator = filter.getOutputDataSet().iterator();
        while (iterator.hasNext()) {
            this.removeDataSetWithOutQuestion(this.pipelineManager.getDataSetList().getVtkObject(iterator.next()));
        }
        iterator = filter.getOutputMapper().iterator();
        while (iterator.hasNext()) {
            this.removeMapperWithOutQuestion(this.pipelineManager.getMapperList().getVtkObject(iterator.next()));
        }
        filter.remove();
        this.pipelineManager.removeVtkObject(vtkObject);
    }

    private void removeMapperWithOutQuestion(VtkObject vtkObject) {
        int n;
        Object[] objectArray = this.pipelineManager.getFilterList().getData().toArray();
        VtkObject vtkObject2 = null;
        for (n = 0; n < objectArray.length; ++n) {
            vtkObject2 = (VtkObject)objectArray[n];
            if (!((Filter)vtkObject2.getVtkObject()).getInputMapper().remove(vtkObject.getVtkObject())) continue;
            this.removeFilter(vtkObject2);
        }
        objectArray = this.pipelineManager.getActorList().getData().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            vtkObject2 = (VtkObject)objectArray[n];
            if (vtkObject2.getVtkObject() instanceof vtkActor) {
                if (((vtkActor)vtkObject2.getVtkObject()).GetMapper() == null || !((vtkActor)vtkObject2.getVtkObject()).GetMapper().equals(vtkObject.getVtkObject())) continue;
                this.removeActorWithOutQuestion(vtkObject2);
                continue;
            }
            if (!(vtkObject2.getVtkObject() instanceof vtkActor2D) || ((vtkActor2D)vtkObject2.getVtkObject()).GetMapper() == null || !((vtkActor2D)vtkObject2.getVtkObject()).GetMapper().equals(vtkObject.getVtkObject())) continue;
            this.removeActorWithOutQuestion(vtkObject2);
        }
        this.pipelineManager.removeVtkObject(vtkObject);
    }

    private void removeDataSetWithOutQuestion(VtkObject vtkObject) {
        int n;
        Object[] objectArray = this.pipelineManager.getFilterList().getData().toArray();
        VtkObject vtkObject2 = null;
        for (n = 0; n < objectArray.length; ++n) {
            vtkObject2 = (VtkObject)objectArray[n];
            if (!((Filter)vtkObject2.getVtkObject()).getInputDataSet().remove(vtkObject.getVtkObject())) continue;
            this.removeFilterWithOutQuestion(vtkObject2);
        }
        objectArray = this.pipelineManager.getMapperList().getData().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            vtkObject2 = (VtkObject)objectArray[n];
            if (((vtkMapper)vtkObject2.getVtkObject()).GetInputAsDataSet() == null || !((vtkMapper)vtkObject2.getVtkObject()).GetInputAsDataSet().equals(vtkObject.getVtkObject())) continue;
            this.removeMapperWithOutQuestion(vtkObject2);
        }
        this.pipelineManager.removeVtkObject(vtkObject);
    }
}

