/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.threshold;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.threshold.ThresholdPlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import vtk.vtkDataSet;

public class ThresholdControlUI
extends JDialog
implements ActionListener {
    private PipeLineManager pipeLineManager;
    private ThresholdPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JFormattedTextField lowerLevel;
    private JFormattedTextField upperLevel;
    private JRadioButton thresholdBetween;
    private JRadioButton thresholdByLower;
    private JRadioButton thresholdByUpper;

    public ThresholdControlUI(PipeLineManager pipeLineManager, ThresholdPlugin thresholdPlugin, Frame frame) {
        super(frame, "Threshold configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = thresholdPlugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), thresholdPlugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener(this);
        jPanel.add((Component)this.inputDataset, "Center");
        jPanel.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Levels"));
        this.lowerLevel = new JFormattedTextField((Object)"0");
        this.lowerLevel.setValue(new Double(-1.0));
        this.upperLevel = new JFormattedTextField((Object)"0");
        this.upperLevel.setValue(new Double(1.0));
        jPanel.add(new JLabel("Lower level"));
        jPanel.add(new JLabel("Upper level"));
        jPanel.add(this.lowerLevel);
        jPanel.add(this.upperLevel);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Threshold type"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.thresholdBetween = new JRadioButton("Threshold between", true);
        this.thresholdByLower = new JRadioButton("Threshold by lower", false);
        this.thresholdByUpper = new JRadioButton("Threshold by upper", false);
        buttonGroup.add(this.thresholdBetween);
        buttonGroup.add(this.thresholdByLower);
        buttonGroup.add(this.thresholdByUpper);
        jPanel.add(this.thresholdBetween);
        jPanel.add(this.thresholdByLower);
        jPanel.add(this.thresholdByUpper);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel();
        JButton jButton = new JButton("Update");
        jButton.setActionCommand("UPDATE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add(jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(300, dimension.height);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double[] dArray;
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        if (string.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                int n = 0;
                if (this.thresholdBetween.isSelected()) {
                    n = 1;
                }
                if (this.thresholdByLower.isSelected()) {
                    n = 2;
                }
                if (this.thresholdByUpper.isSelected()) {
                    n = 3;
                }
                this.plugin.updateThreshold((vtkDataSet)((VtkObject)this.datasetModel.getSelectedItem()).getVtkObject(), n, ((Number)this.lowerLevel.getValue()).doubleValue(), ((Number)this.upperLevel.getValue()).doubleValue());
            }
        } else if (string.equals("CANCEL")) {
            this.dispose();
        } else if (this.datasetModel.getSelectedItem() != null && (dArray = ((vtkDataSet)((VtkObject)this.datasetModel.getSelectedItem()).getVtkObject()).GetScalarRange()) != null) {
            this.lowerLevel.setValue(new Double(dArray[0]));
            this.upperLevel.setValue(new Double(dArray[1]));
        }
    }
}

