#!/usr/bin/env python

"""
setup.py for installing the VTK-Python bindings using distutils.

Created by Prabhu Ramachandran, June 2002.

"""

import glob, sys, os
from types import StringType
from distutils.core import setup
from distutils.util import change_root, convert_path
from distutils.command.install_data import install_data
from distutils.sysconfig import get_config_var

version = "4.2.1"

build_lib_dir = "/usr/local/VTK-4.2.1/bin"

build_bin_dir = "/usr/local/VTK-4.2.1/bin"

# You can change this to suit your needs.  However you must make sure
# that under *nix the libvtk*Python*.so in the specified directory.
install_lib_dir = "/usr/local/lib/vtk"


def get_libs():
    """Returns a list of libraries to be installed.  """
    libs = []
    if os.name == 'posix':
        libs = glob.glob(os.path.abspath(os.path.join(
            install_lib_dir, 'libvtk*Python*' + get_config_var('SO'))))
    else:
        d = os.path.normpath(build_lib_dir)
        if not os.path.isfile(os.path.join(d, 'vtkCommonPython.dll')):
            d = os.path.normpath(os.path.join(build_lib_dir, 'release'))
            
        libs = glob.glob(os.path.join(d, 'vtk*Python.dll'))

    return libs


def get_scripts():    
    """Returns the appropriate vtkpython executable and pvtkpython
    that is to be installed."""
    scripts = []
    if os.name == 'posix':
        for i in ('vtkpython', 'pvtkpython'):
            f = os.path.join(build_bin_dir, i)
            if os.path.exists(f):
                scripts.append(f)
    else:
        win32_bin_dir = build_bin_dir
        for subdir in ('Debug', 'Release', 'MinSizeRel',
                       'RelWithDebInfo'):
            win32_bin_dir = os.path.join(build_bin_dir, subdir)
            if os.path.exists(win32_bin_dir):
                break
        for i in ('vtkpython.exe', 'pvtkpython.exe'):
            f = os.path.join(os.path.normpath(win32_bin_dir), i)
            if os.path.exists(f):
                scripts.append(f)
    return scripts


class my_install_data (install_data):
    def finalize_options (self):
        """Needed to make this thing work properly."""
        self.set_undefined_options ('install',
                                    ('install_lib', 'install_dir'),
                                    ('root', 'root'),
                                    ('force', 'force'),
                                    )
    def run (self):
        """Slightly modified from original to make symlinks to the
        libvtk*Python.so libraries"""
        self.mkpath(self.install_dir)
        for f in self.data_files:
            if type(f) == StringType:
                # it's a simple file, so copy it
                f = convert_path(f)
                if self.warn_dir:
                    self.warn("setup script did not provide a directory for "
                              "'%s' -- installing right in '%s'" %
                              (f, self.install_dir))
                (out, _) = self.copy_file(f, self.install_dir)
                self.outfiles.append(out)
            else:
                # it's a tuple with path to install to and a list of files
                dir = convert_path(f[0])
                if not os.path.isabs(dir):
                    dir = os.path.join(self.install_dir, dir)
                elif self.root:
                    dir = change_root(self.root, dir)
                self.mkpath(dir)
                for data in f[1]:
                    data = convert_path(data)
                    # do symlinking if ! posix and library.
                    if (os.path.basename(data)[:6] == 'libvtk') and \
                       (os.name == 'posix'):
                        (out, _) = self.copy_file(data, dir, link='sym')
                    else:
                        (out, _) = self.copy_file(data, dir)
                    self.outfiles.append(out)
      
        

setup (name              = "VTK",
       version           = version,
       description       = "The Visualization Toolkit",
       maintainer        = "VTK Developers",
       maintainer_email  = "vtk-developers@public.kitware.com",
       licence           = "BSD",
       long_description  = "A high level visualization library",
       url               = "http://www.vtk.org/",
       platforms         = ['Any'],
       cmdclass          = {'install_data': my_install_data},
       packages          = ['vtk_python', 'vtk_python.vtk',
                            'vtk_python.vtk.gtk', 'vtk_python.vtk.qt',
                            'vtk_python.vtk.tk', 'vtk_python.vtk.util',
                            'vtk_python.vtk.wx', 'vtk_python.vtk.test'],
       scripts           = get_scripts(),
       package_dir       = {'vtk_python': '.'},
       data_files        = [('vtk_python', get_libs()), ('.', ['vtk.pth'])]
       )
