
import os,sys
import java

class launcher:
   def __init__(self):
          self.system = os._getOsType()
          print 'system= '+self.system
          self.osName = java.lang.System.getProperty("os.name")
          print 'OS name= '+self.osName
          self.platform=sys.platform
          print 'JVM= '+self.platform
          self.javaHome = java.lang.System.getProperty("java.home")
          print 'Java home= '+ self.javaHome
          self.CassandraHome= os.getcwd()
          print 'Cassandra Home= '+self.CassandraHome

          self.setScripts()


   def perform(self, inputCmd):
         os.system(inputCmd)


   def setScripts(self):

        # for Mac OS X
        self.OSXSettingScript = {"VTK_HOME":"/Users/juju/VTK/VTKOSX/CompilationSpace/",
                                 "LD_LIBRARY_PATH":"/Users/juju/VTK/VTKOSX/CompilationSpace/bin/:${LD_LIBRARY_PATH}",
                                 "CLASSPATH2":"${VTK_HOME}/bin/vtk.jar:$CLASSPATH",
                                 "DYLD_LIBRARY_PATH":"/Users/juju/VTK/VTKOSX/CompilationSpace/bin/:${VTK_HOME}/lib/vtk/:$LD_LIBRARY_PATH",
                                 "VTKJAVAWRAPPING":"${VTKHOME}/Wrapping/Java",
                                 "CLASSPATH3":"${VTKJAVAWRAPPING}:$CLASSPATH2"}
        self.OSXCmd = "java -cp ${VTKHOME}/Wrapping/Java:$LD_LIBRARY_PATH/vtk.jar:./plugin:$CLASSPATH. -jar Cassandra.jar plugin"




        # for embeded Linux version
        self.LinuxSettingScript = {"VTK_HOME":"./ThirdPart/vtk/vtk42-linux/",
                                   "LD_LIBRARY_PATH":"./ThirdPart/vtk/vtk42-linux/bin/:./ThirdPart/vtk/vtk42-linux/lib",
                                   }

        self.linuxCp  = self.CassandraHome+"/ThirdPart/vtk/vtk42-linux/bin/vtk.jar:"
        self.linuxCp  = self.linuxCp + self.CassandraHome+"/Cassandra.jar:"
        self.linuxCp  = self.linuxCp + self.CassandraHome+"/ThirdPart/jython-2.1/jython.jar:"
        self.linuxCp  = self.linuxCp + self.CassandraHome+"/ThirdPart/skinlf/skinlf.jar:"
        self.linuxCp  = self.linuxCp + self.CassandraHome+"/ThirdPart/artenum/dedalegraph/DedaleGraph.jar:"
        self.linuxCp  = self.linuxCp + self.CassandraHome+"/ThirdPart/artenum/jyconsole/JyConsole.jar:"
        self.linuxCp  = self.linuxCp + self.CassandraHome+"/ThirdPart/artenum/cassandra/ArtenumPipeLineManager.jar"

        self.LinuxCmd = "java -cp \""+self.linuxCp+":.\" com.artenum.cassandra.Cassandra "
      


        # for windows 
        self.pathToVTK = self.CassandraHome+"\\ThirdPart\\vtk\\vtk42-win\\bin;"+self.CassandraHome+"\\ThirdPart\\vtk\\vtk42-win\\lib"

        self.winSettingScript = {"PATH":self.javaHome+"\\bin;"+self.CassandraHome+"\\ThirdPart\\vtk\\vtk42-win\\bin;"+os.environ["PATH"],
                                 "LD_LIBRARY_PATH":self.CassandraHome+"\\ThirdPart\\vtk\\vtk42-win\\lib"}

        self.winCp  = self.CassandraHome+"\\ThirdPart\\vtk\\vtk42-win\\bin\\vtk.jar;"
        self.winCp  = self.winCp + self.CassandraHome+"\\Cassandra.jar;"
        self.winCp  = self.winCp + self.CassandraHome+"\\ThirdPart\\jython-2.1\\jython.jar;"
        self.winCp  = self.winCp + self.CassandraHome+"\\ThirdPart\\skinlf\\skinlf.jar;"
        self.winCp  = self.winCp + self.CassandraHome+"\\ThirdPart\\artenum\\dedalegraph\\DedaleGraph.jar;"
        self.winCp  = self.winCp + self.CassandraHome+"\\ThirdPart\\artenum\\jyconsole\\JyConsole.jar;"
        self.winCp  = self.winCp + self.CassandraHome+"\\ThirdPart\\artenum\\cassandra\\ArtenumPipeLineManager.jar"

        self.winCmd = "java -cp \""+self.winCp+";.\" com.artenum.cassandra.Cassandra "


   if __name__ == "__main__":
      
       from run import launcher
 
       lh = launcher()

       if (lh.system == "posix"):
          if(lh.osName == "Mac OS X"):
              settingScript = lh.OSXSettingScript
              launchCmd = lh.OSXCmd 
          elif(lh.osName == "Linux"):
              settingScript = lh.LinuxSettingScript
              launchCmd = os.path.join(lh.javaHome, 'bin', lh.LinuxCmd)

       else:
              settingScript = lh.winSettingScript
              #launchCmd = os.path.join(lh.javaHome, "bin", lh.winCmd)
              launchCmd = lh.winCmd
              print launchCmd

       # now we start the action
       for key in settingScript.keys():
              os.environ[key]=settingScript[key]
       os.system(launchCmd)
