/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;

import vtk.vtkLookupTable;
import vtk.vtkMapper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;

import java.util.Iterator;

import javax.swing.JPopupMenu;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Cassandra toolbox.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class CassandraToolBox {
    public static Frame getParentFrame(Component c) {
        Component currentComponent = c;
        while ((currentComponent != null) && !(currentComponent instanceof Frame)) {
            if (currentComponent instanceof JPopupMenu) {
                currentComponent = ((JPopupMenu) currentComponent).getInvoker();
            } else {
                currentComponent = currentComponent.getParent();
            }
        }

        return (Frame) currentComponent;
    }

    public static Dialog getParentDialog(Component c) {
        Component currentComponent = c;
        while ((currentComponent != null) && !(currentComponent instanceof Dialog)) {
            if (currentComponent instanceof JPopupMenu) {
                currentComponent = ((JPopupMenu) currentComponent).getInvoker();
            } else {
                currentComponent = currentComponent.getParent();
            }
        }

        return (Dialog) currentComponent;
    }

    public static void updateMapper(PipeLineManager pipelineManager, vtkLookupTable lookupTable) {
        for (Iterator i = pipelineManager.getMapperList().getData().iterator(); i.hasNext();) {
            vtkMapper mapper = (vtkMapper) ((VtkObject) i.next()).getVtkObject();
            if (mapper.GetLookupTable().equals(lookupTable)) {
                mapper.SetScalarRange(lookupTable.GetTableRange());
            }
        }
    }

    public static void updateLookupTableRange(vtkLookupTable lookupTable, double min, double max) {
        double realMin = lookupTable.GetTableRange()[0];
        double realMax = lookupTable.GetTableRange()[1];
        if (realMin > min) {
            realMin = min;
        }

        if (realMax < max) {
            realMax = max;
        }

        lookupTable.SetRange(realMin, realMax);
        lookupTable.Build();
    }

    public static Color vtkColorConverter(double r, double g, double b) {
        return new Color((float) r, (float) g, (float) b);
    }

    public static double[] vtkColorConverter(Color c) {
        double[] rgb = new double[3];
        rgb[0] = ((float) c.getRed()) / 255;
        rgb[1] = ((float) c.getGreen()) / 255;
        rgb[2] = ((float) c.getBlue()) / 255;
        return rgb;
    }

    public static Color vtkColorConverter(double[] rvb) {
        return vtkColorConverter(rvb[0], rvb[1], rvb[2]);
    }
}
