/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyFrame;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.SyspathArchive;
import org.python.core.SyspathJavaLoader;
import org.python.core.__builtin__;
import org.python.core.parser;
import org.python.parser.SimpleNode;

public class imp {
    public static final int APIVersion = 9;
    private static Object syspathJavaLoaderLock = new Object();
    private static ClassLoader syspathJavaLoader = null;
    private static PyTuple all = null;
    private static /* synthetic */ Class class$Lorg$python$core$PyRunnable;

    public static PyModule addModule(String name) {
        PyObject modules = Py.getSystemState().modules;
        PyModule module = (PyModule)modules.__finditem__(name);
        if (module != null) {
            return module;
        }
        module = new PyModule(name, null);
        modules.__setitem__(name, (PyObject)module);
        return module;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] readBytes(InputStream fp) {
        try {
            void ioe;
            byte[] buf = new byte[fp.available()];
            fp.read(buf);
            fp.close();
            return ioe;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    private static final InputStream makeStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final PyObject createFromPyClass(String name, InputStream fp, boolean testing, String fileName) {
        void code;
        int n;
        byte[] data = imp.readBytes(fp);
        int api = (data[(n = data.length) - 4] << 24) + (data[n - 3] << 16) + (data[n - 2] << 8) + data[n - 1];
        if (api != 9) {
            if (testing) {
                return null;
            }
            throw Py.ImportError("invalid api version(" + api + " != " + "9" + ") in: " + name);
        }
        try {
            PyCode pyCode = BytecodeLoader.makeCode(name + "$py", data);
        }
        catch (Throwable t) {
            if (testing) {
                return null;
            }
            throw Py.JavaError(t);
        }
        Py.writeComment("import", "'" + name + "' as " + fileName);
        return imp.createFromCode(name, (PyCode)code);
    }

    public static byte[] compileSource(String name, File file) {
        return imp.compileSource(name, file, null, null);
    }

    public static byte[] compileSource(String name, File file, String filename, String outFilename) {
        if (filename == null) {
            filename = file.toString();
        }
        if (outFilename == null) {
            outFilename = filename.substring(0, filename.length() - 3) + "$py.class";
        }
        return imp.compileSource(name, imp.makeStream(file), filename, outFilename);
    }

    static byte[] compileSource(String name, InputStream fp, String filename) {
        String outFilename = null;
        if (filename != null) {
            outFilename = filename.substring(0, filename.length() - 3) + "$py.class";
        }
        return imp.compileSource(name, fp, filename, outFilename);
    }

    static byte[] compileSource(String name, InputStream fp, String filename, String outFilename) {
        try {
            ByteArrayOutputStream ofp = new ByteArrayOutputStream();
            if (filename == null) {
                filename = "<unknown>";
            }
            SimpleNode node = null;
            try {
                node = parser.parse(fp, "exec", filename, null);
            }
            finally {
                Object var7_7 = null;
                fp.close();
            }
            Module.compile(node, ofp, name + "$py", filename, true, false, true, null);
            if (outFilename != null) {
                File classFile = new File(outFilename);
                try {
                    FileOutputStream fop = new FileOutputStream(classFile);
                    ofp.writeTo(fop);
                    fop.close();
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
            return ofp.toByteArray();
        }
        catch (Throwable t) {
            throw parser.fixParseError(null, t, filename);
        }
    }

    private static final PyObject createFromSource(String name, InputStream fp, String filename) {
        byte[] bytes = imp.compileSource(name, fp, filename);
        Py.writeComment("import", "'" + name + "' as " + filename);
        PyCode code = BytecodeLoader.makeCode(name + "$py", bytes);
        return imp.createFromCode(name, code);
    }

    private static final PyObject createFromSource(String name, InputStream fp, String filename, String outFilename) {
        byte[] bytes = imp.compileSource(name, fp, filename, outFilename);
        Py.writeComment("import", "'" + name + "' as " + filename);
        PyCode code = BytecodeLoader.makeCode(name + "$py", bytes);
        return imp.createFromCode(name, code);
    }

    static PyObject createFromCode(String name, PyCode c) {
        PyModule module = imp.addModule(name);
        PyTableCode code = null;
        if (c instanceof PyTableCode) {
            code = (PyTableCode)c;
        }
        PyFrame f = new PyFrame(code, module.__dict__, module.__dict__, null);
        code.call(f);
        return module;
    }

    public static ClassLoader getSyspathJavaLoader() {
        Object object = syspathJavaLoaderLock;
        synchronized (object) {
            if (syspathJavaLoader == null) {
                syspathJavaLoader = new SyspathJavaLoader();
            }
        }
        return syspathJavaLoader;
    }

    private static final PyObject createFromClass(String name, Class c) {
        Class<?>[] interfaces = c.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] == (class$Lorg$python$core$PyRunnable != null ? class$Lorg$python$core$PyRunnable : imp.class$("org.python.core.PyRunnable"))) {
                try {
                    PyObject o = imp.createFromCode(name, ((PyRunnable)c.newInstance()).getMain());
                    return o;
                }
                catch (InstantiationException e) {
                    throw Py.JavaError(e);
                }
                catch (IllegalAccessException e) {
                    throw Py.JavaError(e);
                }
            }
            ++i;
        }
        return PyJavaClass.lookup(c);
    }

    private static final PyObject loadBuiltin(String name, PyList path) {
        Class c;
        if (name == "sys") {
            Py.writeComment("import", "'" + name + "' as sys in " + "builtin modules");
            return Py.java2py(Py.getSystemState());
        }
        String mod = PySystemState.getBuiltin(name);
        if (mod != null && (c = Py.findClassEx(mod, "builtin modules")) != null) {
            Py.writeComment("import", "'" + name + "' as " + mod + " in builtin modules");
            try {
                return imp.createFromClass(name, c);
            }
            catch (NoClassDefFoundError e) {
                throw Py.ImportError("Cannot import " + name + ", missing class " + c.getName());
            }
        }
        return null;
    }

    private static final Class findPyClass(String modName) {
        if (Py.frozenPackage != null) {
            modName = Py.frozenPackage + "." + modName;
        }
        return Py.findClassEx(modName + "$_PyInner", "precompiled");
    }

    private static final PyObject loadPrecompiled(String name, String modName, PyList path) {
        if (Py.frozenModules != null) {
            Class c;
            if (Py.frozenModules.get(modName + ".__init__") != null) {
                c = imp.findPyClass(modName + ".__init__");
                if (c == null) {
                    return null;
                }
                Py.writeComment("import", "'" + modName + "' as " + "precompiled package");
                PyModule m = imp.addModule(modName);
                m.__dict__.__setitem__("__path__", (PyObject)new PyList());
            } else if (Py.frozenModules.get(modName) != null) {
                c = imp.findPyClass(modName);
                if (c == null) {
                    return null;
                }
                Py.writeComment("import", "'" + modName + "' as " + "precompiled module");
            } else {
                return null;
            }
            return imp.createFromClass(modName, c);
        }
        return null;
    }

    static PyObject loadFromZipFile(String name, String modName, SyspathArchive zipArchive) {
        PyObject o = null;
        Object pkgEntry = null;
        String entryName = name;
        String pyName = entryName + ".py";
        String className = entryName + "$py.class";
        try {
            String sourceName = entryName + "/__init__.py";
            String compledName = entryName + "/__init__$py.class";
            ZipEntry sourceEntry = zipArchive.getEntry(sourceName);
            ZipEntry compiledEntry = zipArchive.getEntry(compledName);
            if (sourceEntry != null || compiledEntry != null) {
                Py.writeDebug("import", "trying package: " + modName + " in jar/zip file " + zipArchive);
                PyModule m = imp.addModule(modName);
                SyspathArchive subArchive = zipArchive.makeSubfolder(name);
                PyList zipPath = new PyList(new PyObject[]{subArchive});
                m.__dict__.__setitem__("__path__", (PyObject)zipPath);
                o = imp.loadFromZipFile("__init__", modName, subArchive);
                if (o != null) {
                    return m;
                }
            }
            ZipEntry pyEntry = zipArchive.getEntry(pyName);
            ZipEntry classEntry = zipArchive.getEntry(className);
            if (pyEntry != null) {
                Py.writeDebug("import", "trying source entry: " + pyName + " from jar/zip file " + zipArchive);
                if (classEntry != null) {
                    InputStream is;
                    Py.writeDebug("import", "trying precompiled entry " + className + " from jar/zip file " + zipArchive);
                    long pyTime = pyEntry.getTime();
                    long classTime = classEntry.getTime();
                    if (classTime >= pyTime && (o = imp.createFromPyClass(modName, is = zipArchive.getInputStream(classEntry), true, classEntry.getName())) != null) {
                        return o;
                    }
                }
                InputStream is = zipArchive.getInputStream(pyEntry);
                return imp.createFromSource(modName, is, pyEntry.getName(), null);
            }
        }
        catch (Exception e) {
            Py.writeDebug("import", "loadFromZipFile exception: " + e.toString());
            e.printStackTrace();
        }
        return null;
    }

    private static final boolean isSyspathArchive(PyObject entry, boolean isDir) {
        if (entry instanceof SyspathArchive) {
            return true;
        }
        if (isDir) {
            return false;
        }
        return SyspathArchive.getArchiveName(entry.toString()) != null;
    }

    static PyObject loadFromPath(String name, PyList path) {
        return imp.loadFromPath(name, name, path);
    }

    static PyObject loadFromPath(String name, String modName, PyList path) {
        PyObject o = imp.loadPrecompiled(name, modName, path);
        if (o != null) {
            return o;
        }
        int nlen = name.length();
        String pyName = name + ".py";
        String className = name + "$py.class";
        int n = path.__len__();
        int i = 0;
        while (i < n) {
            block15: {
                File dir;
                boolean isDir;
                PyObject entry = path.__getitem__(i);
                String dirName = entry.toString();
                if (dirName.length() == 0) {
                    dirName = null;
                }
                if (imp.isSyspathArchive(entry, isDir = (dir = new File(dirName, name)).isDirectory())) {
                    PyObject ret;
                    Py.writeDebug("import", "trying " + modName + " in jar/zip file " + dirName);
                    if (!(entry instanceof SyspathArchive)) {
                        try {
                            entry = new SyspathArchive(dirName);
                            path.__setitem__(i, entry);
                        }
                        catch (IOException exc) {
                            break block15;
                        }
                    }
                    if ((ret = imp.loadFromZipFile(name, modName, (SyspathArchive)entry)) != null) {
                        return ret;
                    }
                }
                if (isDir && imp.caseok(dir, name, nlen) && (new File(dir, "__init__.py").isFile() || new File(dir, "__init__$py.class").isFile())) {
                    PyList pkgPath = new PyList();
                    PyModule m = imp.addModule(modName);
                    pkgPath.append(new PyString(dir.toString()));
                    m.__dict__.__setitem__("__path__", (PyObject)pkgPath);
                    o = imp.loadFromPath("__init__", modName, pkgPath);
                    if (o != null) {
                        return m;
                    }
                } else {
                    File pyFile = new File(dirName, pyName);
                    File classFile = new File(dirName, className);
                    Py.writeDebug("import", "trying source " + pyFile.getPath());
                    if (pyFile.isFile() && imp.caseok(pyFile, pyName, nlen)) {
                        if (classFile.isFile() && imp.caseok(classFile, className, nlen)) {
                            PyObject ret;
                            Py.writeDebug("import", "trying precompiled " + classFile.getPath());
                            long pyTime = pyFile.lastModified();
                            long classTime = classFile.lastModified();
                            if (classTime >= pyTime && (ret = imp.createFromPyClass(modName, imp.makeStream(classFile), true, classFile.getPath())) != null) {
                                return ret;
                            }
                        }
                        return imp.createFromSource(modName, imp.makeStream(pyFile), pyFile.getAbsolutePath());
                    }
                    Py.writeDebug("import", "trying " + classFile.getPath());
                    if (classFile.isFile() && imp.caseok(classFile, className, nlen)) {
                        return imp.createFromPyClass(modName, imp.makeStream(classFile), false, classFile.getPath());
                    }
                }
            }
            ++i;
        }
        return null;
    }

    static boolean caseok(File file, String filename, int namelen) {
        if (Options.caseok) {
            return true;
        }
        try {
            File canFile = new File(file.getCanonicalPath());
            return filename.regionMatches(0, canFile.getName(), 0, namelen);
        }
        catch (IOException exc) {
            return false;
        }
    }

    static PyObject loadFromClassLoader(String name, ClassLoader classLoader) {
        String path = name.replace('.', '/');
        boolean loadCompiled = false;
        boolean loadSource = false;
        InputStream istream = classLoader.getResourceAsStream(path + "/__init__.py");
        if (istream != null) {
            PyModule m = imp.addModule(name);
            m.__dict__.__setitem__("__path__", Py.None);
            return imp.createFromSource(name, istream, null);
        }
        istream = classLoader.getResourceAsStream(path + ".py");
        if (istream != null) {
            return imp.createFromSource(name, istream, null);
        }
        return null;
    }

    private static final PyObject load(String name, PyList path) {
        PyObject ret = imp.loadBuiltin(name, path);
        if (ret != null) {
            return ret;
        }
        ret = imp.loadFromPath(name, path);
        if (ret != null) {
            return ret;
        }
        Py.writeDebug("import", "trying " + name + " in packagemanager");
        ret = PySystemState.packageManager.lookupName(name);
        if (ret != null) {
            Py.writeComment("import", "'" + name + "' as java package");
            return ret;
        }
        Py.writeComment("import", "'" + name + "' not found (=> ImportError)");
        return null;
    }

    public static PyObject load(String name) {
        return imp.import_first(name, new StringBuffer(""));
    }

    private static final String getParent(PyObject dict) {
        PyObject tmp = dict.__finditem__("__name__");
        if (tmp == null) {
            return null;
        }
        String name = tmp.toString();
        tmp = dict.__finditem__("__path__");
        if (tmp != null && tmp instanceof PyList) {
            return name.intern();
        }
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return name.substring(0, dot).intern();
    }

    private static final PyObject import_next(PyObject mod, StringBuffer parentNameBuffer, String name) {
        if (parentNameBuffer.length() > 0) {
            parentNameBuffer.append('.');
        }
        parentNameBuffer.append(name);
        String fullName = parentNameBuffer.toString().intern();
        PyObject modules = Py.getSystemState().modules;
        PyObject ret = modules.__finditem__(fullName);
        if (ret != null) {
            return ret;
        }
        ret = mod == null ? imp.load(name.intern(), Py.getSystemState().path) : mod.impAttr(name.intern());
        if (ret == null || ret == Py.None) {
            return ret;
        }
        if (modules.__finditem__(fullName) == null) {
            modules.__setitem__(fullName, ret);
        } else {
            ret = modules.__finditem__(fullName);
        }
        return ret;
    }

    private static final PyObject import_first(String name, StringBuffer parentNameBuffer) {
        PyObject ret = imp.import_next(null, parentNameBuffer, name);
        if (ret == null || ret == Py.None) {
            throw Py.ImportError("no module named " + name);
        }
        return ret;
    }

    private static final PyObject import_logic(PyObject mod, StringBuffer parentNameBuffer, String dottedName) {
        int dot = 0;
        int last_dot = 0;
        do {
            String name;
            if ((dot = dottedName.indexOf(46, last_dot)) == -1) {
                String string2 = dottedName.substring(last_dot);
            } else {
                name = dottedName.substring(last_dot, dot);
            }
            mod = imp.import_next(mod, parentNameBuffer, name);
            if (mod == null || mod == Py.None) {
                throw Py.ImportError("No module named " + name);
            }
            last_dot = dot + 1;
        } while (dot != -1);
        return mod;
    }

    public static PyObject import_name(String name, boolean top, PyObject modDict) {
        String firstName;
        int dot;
        if (name.length() == 0) {
            throw Py.ValueError("Empty module name");
        }
        PyObject modules = Py.getSystemState().modules;
        PyObject pkgMod = null;
        String pkgName = null;
        if (modDict != null && (pkgMod = modules.__finditem__(pkgName = imp.getParent(modDict))) != null && !(pkgMod instanceof PyModule)) {
            pkgMod = null;
        }
        if ((dot = name.indexOf(46)) == -1) {
            String string2 = name;
        } else {
            firstName = name.substring(0, dot);
        }
        StringBuffer parentNameBuffer = new StringBuffer(pkgMod != null ? pkgName : "");
        PyObject topMod = imp.import_next(pkgMod, parentNameBuffer, firstName);
        if (topMod == Py.None || topMod == null) {
            if (topMod == null) {
                modules.__setitem__(parentNameBuffer.toString().intern(), Py.None);
            }
            parentNameBuffer = new StringBuffer("");
            topMod = imp.import_first(firstName, parentNameBuffer);
        }
        PyObject mod = topMod;
        if (dot != -1) {
            mod = imp.import_logic(topMod, parentNameBuffer, name.substring(dot + 1));
        }
        if (top) {
            return topMod;
        }
        return mod;
    }

    public static PyObject importName(String name, boolean top) {
        return imp.import_name(name, top, null);
    }

    public static synchronized PyObject importName(String name, boolean top, PyObject modDict) {
        return imp.import_name(name, top, modDict);
    }

    public static PyObject importOne(String mod, PyFrame frame) {
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), Py.EmptyTuple);
        return module;
    }

    public static PyObject importOneAs(String mod, PyFrame frame) {
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), imp.getStarArg());
        return module;
    }

    public static PyObject[] importFrom(String mod, String[] names, PyFrame frame) {
        return imp.importFromAs(mod, names, null, frame);
    }

    public static PyObject[] importFromAs(String mod, String[] names, String[] asnames, PyFrame frame) {
        PyObject[] pynames = new PyObject[names.length];
        int i = 0;
        while (i < names.length) {
            pynames[i] = Py.newString(names[i]);
            ++i;
        }
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), new PyTuple(pynames));
        PyObject[] submods = new PyObject[names.length];
        int i2 = 0;
        while (i2 < names.length) {
            PyObject submod = module.__findattr__(names[i2]);
            if (submod == null) {
                throw Py.ImportError("cannot import name " + names[i2]);
            }
            submods[i2] = submod;
            ++i2;
        }
        return submods;
    }

    private static final synchronized PyTuple getStarArg() {
        if (all == null) {
            all = new PyTuple(new PyString[]{Py.newString('*')});
        }
        return all;
    }

    public static void importAll(String mod, PyFrame frame) {
        PyObject names;
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), imp.getStarArg());
        boolean filter = true;
        if (module instanceof PyJavaPackage) {
            PyObject pyObject = ((PyJavaPackage)module).fillDir();
        } else {
            PyObject __all__ = module.__findattr__("__all__");
            if (__all__ != null) {
                names = __all__;
                filter = false;
            } else {
                names = module.__dir__();
            }
        }
        imp.loadNames(names, module, frame.getf_locals(), filter);
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadNames(PyObject names, PyObject module, PyObject locals, boolean filter) {
        PyObject name;
        int i = 0;
        while ((name = names.__finditem__(i++)) != null) {
            void var5_5;
            String sname = ((PyString)var5_5).internedString();
            if (filter && sname.startsWith("_")) continue;
            try {
                locals.__setitem__(sname, module.__getattr__(sname));
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    static PyObject reload(PyJavaClass c) {
        return c;
    }

    static PyObject reload(PyModule m) {
        PyObject modules = Py.getSystemState().modules;
        String name = m.__getattr__("__name__").toString().intern();
        PyModule nm = (PyModule)modules.__finditem__(name);
        if (nm == null || !nm.__getattr__("__name__").toString().equals(name)) {
            throw Py.ImportError("reload(): module " + name + " not in sys.modules");
        }
        PyList path = Py.getSystemState().path;
        String modName = name;
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            String iname = name.substring(0, dot).intern();
            PyObject pkg = modules.__finditem__(iname);
            if (pkg == null) {
                throw Py.ImportError("reload(): parent not in sys.modules");
            }
            path = (PyList)pkg.__getattr__("__path__");
            name = name.substring(dot + 1, name.length()).intern();
        }
        nm.__setattr__("__name__", (PyObject)new PyString(modName));
        PyObject ret = imp.loadFromPath(name, modName, path);
        modules.__setitem__(modName, ret);
        return ret;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private imp() {
    }
}

