/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.ConnectivityListener;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.graph.impl.DefaultGraphModel;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.GraphViewListener;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;

public class VtkPipeLineGraphModel
extends DefaultGraphModel
implements ListDataListener,
ConnectivityListener {
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private int lastYPos = 0;

    public VtkPipeLineGraphModel(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        pipeLineManager.getActorList().addListDataListener((ListDataListener)this);
        pipeLineManager.getMapperList().addListDataListener((ListDataListener)this);
        pipeLineManager.getDataSetList().addListDataListener((ListDataListener)this);
        pipeLineManager.getFilterList().addListDataListener((ListDataListener)this);
        pipeLineManager.getLookupTableList().addListDataListener((ListDataListener)this);
        pipeLineManager.getScalarBarList().addListDataListener((ListDataListener)this);
        pipeLineManager.getTextActorList().addListDataListener((ListDataListener)this);
        pipeLineManager.addConnectivityListener((ConnectivityListener)this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    public void reload() {
        Object[] objectArray = this.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((VtkObjectCellAdapter)objectArray[i]).savePosition();
        }
        super.reload();
    }

    public void updateCell() {
        VtkObjectUI vtkObjectUI;
        VtkObject vtkObject = null;
        VtkObjectCellAdapter vtkObjectCellAdapter = null;
        Iterator iterator = this.pipeLineManager.getActorList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        iterator = this.pipeLineManager.getMapperList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        iterator = this.pipeLineManager.getDataSetList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
                vtkObjectUI = (VtkObjectUI)((Object)vtkObjectCellAdapter.getUI());
                if (vtkObjectUI.getPosition().y > this.lastYPos) {
                    this.lastYPos = vtkObjectUI.getPosition().y;
                }
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        iterator = this.pipeLineManager.getFilterList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
                vtkObjectUI = (VtkObjectUI)((Object)vtkObjectCellAdapter.getUI());
                if (vtkObjectUI.getPosition().y < this.lastYPos) {
                    vtkObjectUI.getPosition().y = this.lastYPos;
                }
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        iterator = this.pipeLineManager.getLookupTableList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        iterator = this.pipeLineManager.getScalarBarList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        iterator = this.pipeLineManager.getTextActorList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            if (vtkObject.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject);
                vtkObject.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
    }

    public void updateConnection() {
        VtkObject vtkObject;
        Object object;
        Object object2;
        VtkObject vtkObject2;
        this.getConnections().clear();
        Object[] objectArray = this.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Cell)objectArray[i]).getConnections().clear();
        }
        Iterator iterator = this.pipeLineManager.getActorList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject2 = (VtkObject)iterator.next();
            if (!(vtkObject2.getVtkObject() instanceof vtkActor)) continue;
            object2 = ((vtkActor)vtkObject2.getVtkObject()).GetMapper();
            object = this.pipeLineManager.getMapperList().getData().iterator();
            while (object.hasNext()) {
                vtkObject = (VtkObject)object.next();
                if (!vtkObject.getVtkObject().equals(object2)) continue;
                this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
            }
        }
        iterator = this.pipeLineManager.getDataSetList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject2 = (VtkObject)iterator.next();
            object2 = this.pipeLineManager.getMapperList().getData().iterator();
            while (object2.hasNext()) {
                object = (VtkObject)object2.next();
                if (((vtkMapper)object.getVtkObject()).GetInputAsDataSet() == null || !((vtkMapper)object.getVtkObject()).GetInputAsDataSet().equals(vtkObject2.getVtkObject())) continue;
                this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)object.getMetaData().get("CELL"));
            }
        }
        iterator = this.pipeLineManager.getLookupTableList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject2 = (VtkObject)iterator.next();
            object2 = this.pipeLineManager.getMapperList().getData().iterator();
            while (object2.hasNext()) {
                object = (VtkObject)object2.next();
                if (((vtkMapper)object.getVtkObject()).GetLookupTable() == null || !((vtkMapper)object.getVtkObject()).GetLookupTable().equals(vtkObject2.getVtkObject())) continue;
                this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)object.getMetaData().get("CELL"));
            }
            object2 = this.pipeLineManager.getScalarBarList().getData().iterator();
            while (object2.hasNext()) {
                object = (VtkObject)object2.next();
                if (((vtkScalarBarActor)object.getVtkObject()).GetLookupTable() == null || !((vtkScalarBarActor)object.getVtkObject()).GetLookupTable().equals(vtkObject2.getVtkObject())) continue;
                this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)object.getMetaData().get("CELL"));
            }
        }
        iterator = this.pipeLineManager.getFilterList().getData().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            vtkObject2 = (VtkObject)iterator.next();
            object = this.pipeLineManager.getMapperList().getData().iterator();
            while (object.hasNext()) {
                vtkObject = (VtkObject)object.next();
                iterator2 = ((Filter)vtkObject2.getVtkObject()).getInputMapper().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (!object2.equals(vtkObject.getVtkObject())) continue;
                    this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
                }
                iterator2 = ((Filter)vtkObject2.getVtkObject()).getOutputMapper().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (!object2.equals(vtkObject.getVtkObject())) continue;
                    this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
                }
            }
            object = this.pipeLineManager.getActorList().getData().iterator();
            while (object.hasNext()) {
                vtkObject = (VtkObject)object.next();
                iterator2 = ((Filter)vtkObject2.getVtkObject()).getInputActor().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (!object2.equals(vtkObject.getVtkObject())) continue;
                    this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
                }
                iterator2 = ((Filter)vtkObject2.getVtkObject()).getOutputActor().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (!object2.equals(vtkObject.getVtkObject())) continue;
                    this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
                }
            }
            object = this.pipeLineManager.getDataSetList().getData().iterator();
            while (object.hasNext()) {
                vtkObject = (VtkObject)object.next();
                iterator2 = ((Filter)vtkObject2.getVtkObject()).getInputDataSet().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (!object2.equals(vtkObject.getVtkObject())) continue;
                    this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
                }
                iterator2 = ((Filter)vtkObject2.getVtkObject()).getOutputDataSet().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (!object2.equals(vtkObject.getVtkObject())) continue;
                    this.connect((Cell)vtkObject2.getMetaData().get("CELL"), (Cell)vtkObject.getMetaData().get("CELL"));
                }
            }
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        VtkObjectCellAdapter vtkObjectCellAdapter = null;
        Object[] objectArray = this.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            vtkObjectCellAdapter = (VtkObjectCellAdapter)objectArray[i];
            if (this.pipeLineManager.getVtkObject(vtkObjectCellAdapter.getVtkObject().getId()) != null) continue;
            Iterator iterator = this.viewListenerList.iterator();
            while (iterator.hasNext()) {
                ((GraphViewListener)iterator.next()).removeCell((Cell)vtkObjectCellAdapter);
            }
            this.getCellList().remove(vtkObjectCellAdapter);
        }
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    public void connectivityChange(VtkObject vtkObject) {
        this.updateConnection();
        this.reload();
    }

    public PipeLineManager getPipelineManager() {
        return this.pipeLineManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }
}

