/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.CuttingPlanePipeLine;
import java.util.ArrayList;
import java.util.Iterator;
import vtk.vtkDataSet;
import vtk.vtkProp;

public class CuttingPlaneAnimation
extends Thread {
    private vtkDataSet dataset;
    private ArrayList list;
    private boolean keepGoing = true;
    private PipeLineManager pipeLineManager;
    private int speed = 100;
    private double reduction = 0.25;

    public CuttingPlaneAnimation(PipeLineManager pipeLineManager, vtkDataSet vtkDataSet2, double d, double d2, double d3, double d4, double d5, double d6, int n, boolean bl) {
        this.dataset = vtkDataSet2;
        this.pipeLineManager = pipeLineManager;
        this.list = new ArrayList();
        for (int i = 0; i < n; ++i) {
            CuttingPlanePipeLine cuttingPlanePipeLine = new CuttingPlanePipeLine(vtkDataSet2, d, d2, d3, d4 + d * (double)i, d5 + d2 * (double)i, d6 + d3 * (double)i);
            if (bl) {
                pipeLineManager.setActorVisible(pipeLineManager.addActor((Object)cuttingPlanePipeLine.getActor(), "Slice actor"), true);
            } else {
                pipeLineManager.getCassandraView().GetRenderer().AddActor((vtkProp)cuttingPlanePipeLine.getActor());
            }
            this.list.add(cuttingPlanePipeLine);
        }
        this.setPriority(1);
    }

    public void run() {
        CuttingPlanePipeLine cuttingPlanePipeLine = null;
        CuttingPlanePipeLine cuttingPlanePipeLine2 = null;
        ArrayList<CuttingPlanePipeLine> arrayList = new ArrayList<CuttingPlanePipeLine>();
        while (this.keepGoing) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                cuttingPlanePipeLine = (CuttingPlanePipeLine)iterator.next();
                arrayList.add(cuttingPlanePipeLine);
                cuttingPlanePipeLine.getActor().GetProperty().SetOpacity(1.0);
                Iterator iterator2 = this.list.iterator();
                while (iterator2.hasNext()) {
                    cuttingPlanePipeLine2 = (CuttingPlanePipeLine)iterator2.next();
                    cuttingPlanePipeLine2.getActor().GetProperty().SetOpacity(cuttingPlanePipeLine2.getActor().GetProperty().GetOpacity() - this.reduction);
                }
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    CuttingPlaneAnimation.sleep(this.speed);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("sleep error");
                }
            }
            while (!arrayList.isEmpty()) {
                cuttingPlanePipeLine = (CuttingPlanePipeLine)arrayList.remove(arrayList.size() - 1);
                cuttingPlanePipeLine.getActor().GetProperty().SetOpacity(1.0);
                iterator = this.list.iterator();
                while (iterator.hasNext()) {
                    cuttingPlanePipeLine2 = (CuttingPlanePipeLine)iterator.next();
                    if (cuttingPlanePipeLine.equals(cuttingPlanePipeLine2)) continue;
                    cuttingPlanePipeLine2.getActor().GetProperty().SetOpacity(cuttingPlanePipeLine2.getActor().GetProperty().GetOpacity() - this.reduction);
                }
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    CuttingPlaneAnimation.sleep(this.speed);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("sleep error");
                }
            }
        }
    }

    public void stopWorking() {
        this.keepGoing = false;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public void setReduction(double d) {
        this.reduction = d;
    }
}

