/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra;

import com.artenum.cassandra.PreferenceListener;
import com.artenum.cassandra.action.CassandraActionListener;
import com.artenum.cassandra.action.SystemExit;
import com.artenum.cassandra.action.menu.AddArrow;
import com.artenum.cassandra.action.menu.AddCone;
import com.artenum.cassandra.action.menu.AddCube;
import com.artenum.cassandra.action.menu.AddLookupTable;
import com.artenum.cassandra.action.menu.AddPlaque;
import com.artenum.cassandra.action.menu.AddScalarBar;
import com.artenum.cassandra.action.menu.AddTxtActor;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.SimplePipeLineManager;
import com.artenum.cassandra.plugin.PluginIntegrationManager;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.CassandraGUI;
import com.artenum.cassandra.ui.CassandraMenu;
import com.artenum.cassandra.ui.CassandraToolBar;
import com.artenum.cassandra.vtk.CassandraView;
import com.artenum.jyconsole.util.PropertyLoader;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Cassandra {
    private CassandraGUI gui;
    private CassandraMenu menu;
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private CassandraActionListener actionListener;
    private CassandraToolBar toolBar;
    private Hashtable preferences = new Hashtable();
    private ArrayList prefListener = new ArrayList();

    public Cassandra() {
        this.pipeLineManager = new SimplePipeLineManager();
        this.pluginManager = new PluginManager();
        this.gui = new CassandraGUI(this.pipeLineManager, this.pluginManager);
        this.actionListener = new CassandraActionListener(this.gui, this.pipeLineManager, this.pluginManager);
        this.menu = new CassandraMenu(this.actionListener);
        this.toolBar = new CassandraToolBar(this.actionListener);
        this.actionListener.reloadPlugings();
        this.gui.update();
        this.addPreferenceListener(this.actionListener);
        this.addPreferenceListener(this.gui);
        this.gui.hideConsole();
        this.gui.getPyConsole().getInterpreter().set("cassandra", (Object)this);
        this.menu.addToolMenuComponent(new AddLookupTable("Add a Lookup Table", this.pipeLineManager));
        this.menu.addToolMenuComponent(new AddScalarBar("Add a ScalarBar", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddCone("Add a cone", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddCube("Add a cube", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddPlaque("Add a plaque", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddArrow("Add a arrow", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddTxtActor("Add a text", this.pipeLineManager));
        File file = null;
        if (System.getProperty("cassandra.pref.image.save.dir") != null && (file = new File(System.getProperty("cassandra.pref.image.save.dir"))).exists()) {
            this.setPreference("cassandra.pref.image.save.dir", file);
        }
        if (System.getProperty("cassandra.pref.plugin.dir") != null && (file = new File(System.getProperty("cassandra.pref.plugin.dir"))).exists()) {
            this.setPreference("cassandra.pref.plugin.dir", file);
        }
        if (System.getProperty("cassandra.pref.vtk.file.dir") != null && (file = new File(System.getProperty("cassandra.pref.vtk.file.dir"))).exists()) {
            this.setPreference("cassandra.pref.vtk.file.dir", file);
        }
        if (System.getProperty("cassandra.pref.script.dir") != null && (file = new File(System.getProperty("cassandra.pref.script.dir"))).exists()) {
            this.setPreference("cassandra.pref.script.dir", file);
        }
    }

    public JComponent getDefaultUI() {
        return this.gui;
    }

    public CassandraMenu getDefaultMenu() {
        return this.menu;
    }

    public PipeLineManager getPipeLineManager() {
        return this.pipeLineManager;
    }

    public CassandraView getRendererPanel() {
        return this.pipeLineManager.getCassandraView();
    }

    public CassandraToolBar getDefaultToolBar() {
        return this.toolBar;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CassandraActionListener getActionManager() {
        return this.actionListener;
    }

    public void loadPluginInDirectory(File file) {
        PluginIntegrationManager.getInstance().loadDirectory(file);
        this.actionListener.reloadPlugings();
    }

    public void addPreferenceListener(PreferenceListener preferenceListener) {
        preferenceListener.setPreferences(this.getPreferences());
        this.prefListener.add(preferenceListener);
    }

    public void removePreferenceListener(PreferenceListener preferenceListener) {
        this.prefListener.remove(preferenceListener);
    }

    public void setPreference(String string, Object object) {
        this.preferences.put(string, object);
        this.notifyPreferenceListener();
    }

    public Hashtable getPreferences() {
        return this.preferences;
    }

    public void notifyPreferenceListener() {
        Iterator iterator = this.prefListener.iterator();
        while (iterator.hasNext()) {
            ((PreferenceListener)iterator.next()).preferenceChanged();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        File file;
        JFrame jFrame;
        Object object;
        try {
            PropertyLoader.loadProperties((String)"./config.properties");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (System.getProperty("cassandra.skin") != null && new File(System.getProperty("cassandra.skin")).exists()) {
            try {
                object = new File(System.getProperty("cassandra.skin"));
                if (((File)object).exists()) {
                    jFrame = SkinLookAndFeel.loadThemePack((String)((File)object).getAbsolutePath());
                    SkinLookAndFeel.setSkin((Skin)jFrame);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Skin error: " + exception.getMessage());
            }
        }
        object = new Cassandra();
        jFrame = new JFrame("Cassandra VTK viewer");
        jFrame.setJMenuBar(((Cassandra)object).getDefaultMenu());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)((Cassandra)object).getDefaultToolBar(), "North");
        jFrame.getContentPane().add((Component)((Cassandra)object).getDefaultUI(), "Center");
        jFrame.setSize(600, 400);
        jFrame.setLocationRelativeTo(null);
        if (stringArray.length == 1) {
            ((Cassandra)object).loadPluginInDirectory(new File(stringArray[0]));
        } else if (System.getProperty("cassandra.plugin.dir") != null && (file = new File(System.getProperty("cassandra.plugin.dir"))).exists()) {
            ((Cassandra)object).loadPluginInDirectory(file);
        }
        ((Cassandra)object).getActionManager().setExitAction(new SystemExit());
        jFrame.setVisible(true);
        ((Cassandra)object).gui.showPipeLine();
    }
}

