/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin;

import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;

public class PluginIntegrationManager
extends URLClassLoader {
    private static PluginIntegrationManager pluginManager;
    private ArrayList pluginList = new ArrayList();

    private PluginIntegrationManager() {
        super(new URL[0]);
    }

    public static PluginIntegrationManager getInstance() {
        if (pluginManager == null) {
            pluginManager = new PluginIntegrationManager();
        }
        return pluginManager;
    }

    public void loadDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            pluginManager.addJar(fileArray[i]);
        }
    }

    public void addJar(File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            try {
                URL uRL = new URL("file", "", file.getAbsolutePath());
                System.out.println("Inspect jar: " + uRL);
                JarFile jarFile = new JarFile(file);
                String string = jarFile.getManifest().getMainAttributes().getValue("Cassandra-Plugin");
                if (string != null) {
                    this.addURL(uRL);
                    String[] stringArray = string.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].length() <= 0) continue;
                        System.out.println("Loading : " + stringArray[i]);
                        this.pluginList.add(stringArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public CassandraPluginIntegrator getPluginIntegrator(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (CassandraPluginIntegrator)this.loadClass(string).newInstance();
    }

    public Collection getPluginIntegratorList() {
        return this.pluginList;
    }
}

