/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import vtk.vtkLookupTable;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ScalarBarControlDialog
extends JDialog
implements ActionListener {
    private VtkObject scalarBar;
    private JComboBox lookupTableComboBox;
    private JRadioButton horizontal;
    private JRadioButton vertical;
    private JTextField title;
    private JFormattedTextField x;
    private JFormattedTextField y;
    private JFormattedTextField width;
    private JFormattedTextField height;
    private JSpinner nbColor;
    private VtkObjectComboBoxModel lookupTableModel;
    private PipeLineManager pipelineManager;
    private JButton exit;
    private JButton update;

    public ScalarBarControlDialog(Frame frame, PipeLineManager pipeLineManager) {
        super(frame, "Scalar Bar control");
        this.pipelineManager = pipeLineManager;
        this.lookupTableModel = new VtkObjectComboBoxModel(pipeLineManager.getLookupTableList(), null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Title"));
        this.title = new JTextField();
        jPanel.add((Component)this.title, "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(4, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(4, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Shape"));
        this.x = new JFormattedTextField((Object)"0");
        this.x.setValue(new Double(0.0));
        this.x.setColumns(20);
        this.y = new JFormattedTextField((Object)"0");
        this.y.setValue(new Double(0.0));
        this.width = new JFormattedTextField((Object)"0");
        this.width.setValue(new Double(0.0));
        this.height = new JFormattedTextField((Object)"0");
        this.height.setValue(new Double(0.0));
        jPanel2.add(new JLabel("x : ", 4));
        jPanel2.add(new JLabel("y : ", 4));
        jPanel2.add(new JLabel("width : ", 4));
        jPanel2.add(new JLabel("height : ", 4));
        jPanel3.add(this.x);
        jPanel3.add(this.y);
        jPanel3.add(this.width);
        jPanel3.add(this.height);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        this.getContentPane().add(jPanel);
        this.horizontal = new JRadioButton("Horizontal");
        this.vertical = new JRadioButton("Vertical");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.horizontal.addActionListener(this);
        this.vertical.addActionListener(this);
        buttonGroup.add(this.horizontal);
        buttonGroup.add(this.vertical);
        jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Orientation"));
        jPanel.add(this.horizontal);
        jPanel.add(this.vertical);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Lookup table"));
        this.lookupTableComboBox = new JComboBox(this.lookupTableModel);
        jPanel.add((Component)this.lookupTableComboBox, "Center");
        this.getContentPane().add(jPanel);
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarBarControlDialog.this.updateScalarBar();
            }
        });
        this.exit = new JButton("Cancel");
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarBarControlDialog.this.dispose();
            }
        });
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.update);
        jPanel.add(this.exit);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void setScalarBar(VtkObject vtkObject) {
        this.scalarBar = vtkObject;
        this.width.setValue(new Double(this.getVtkScalarBar().GetWidth()));
        this.height.setValue(new Double(this.getVtkScalarBar().GetHeight()));
        double[] dArray = this.getVtkScalarBar().GetPosition();
        this.x.setValue(new Double(dArray[0]));
        this.y.setValue(new Double(dArray[1]));
        this.title.setText(this.getVtkScalarBar().GetTitle());
        this.vertical.setSelected(this.getVtkScalarBar().GetOrientation() == 1);
        this.lookupTableModel.setSelectedEncapsulateItem(this.getVtkScalarBar().GetLookupTable());
    }

    public void updateScalarBar() {
        this.getVtkScalarBar().SetWidth(((Number)this.width.getValue()).doubleValue());
        this.getVtkScalarBar().SetHeight(((Number)this.height.getValue()).doubleValue());
        this.getVtkScalarBar().SetPosition(((Number)this.x.getValue()).doubleValue(), ((Number)this.y.getValue()).doubleValue());
        this.getVtkScalarBar().SetTitle(this.title.getText());
        if (this.horizontal.isSelected()) {
            this.getVtkScalarBar().SetOrientationToHorizontal();
        } else {
            this.getVtkScalarBar().SetOrientationToVertical();
        }
        this.getVtkScalarBar().SetLookupTable((vtkScalarsToColors)((vtkLookupTable)((VtkObject)this.lookupTableModel.getSelectedItem()).getVtkObject()));
        this.pipelineManager.notifyConnectivityChange(this.scalarBar);
        this.pipelineManager.validateView();
    }

    public vtkScalarBarActor getVtkScalarBar() {
        return (vtkScalarBarActor)this.scalarBar.getVtkObject();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Number number = (Number)this.x.getValue();
        Number number2 = (Number)this.y.getValue();
        Number number3 = (Number)this.width.getValue();
        Number number4 = (Number)this.height.getValue();
        this.x.setValue(number2);
        this.y.setValue(number);
        this.height.setValue(number3);
        this.width.setValue(number4);
    }
}

