/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Timer;
import vtk.vtkBoxWidget;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorObserver;
import vtk.vtkInteractorStyle;
import vtk.vtkPanel;
import vtk.vtkPlaneWidget;
import vtk.vtkProp3D;
import vtk.vtkRenderWindowInteractor;

public class vtkCanvas
extends vtkPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    protected vtkGenericRenderWindowInteractor iren = new vtkGenericRenderWindowInteractor();
    protected Timer timer = new Timer(10, new DelayAction());
    protected int ctrlPressed = 0;
    protected int shiftPressed = 0;
    protected vtkPlaneWidget pw = new vtkPlaneWidget();
    protected vtkBoxWidget bw = new vtkBoxWidget();

    public vtkCanvas() {
        this.iren.SetRenderWindow(this.rw);
        this.iren.AddObserver("CreateTimerEvent", (Object)this, "StartTimer");
        this.iren.AddObserver("DestroyTimerEvent", (Object)this, "DestroyTimer");
        this.iren.SetSize(200, 200);
        this.iren.ConfigureEvent();
        this.pw.AddObserver("EnableEvent", (Object)this, "BeginPlaneInteraction");
        this.bw.AddObserver("EnableEvent", (Object)this, "BeginBoxInteraction");
        this.pw.SetKeyPressActivationValue('l');
        this.bw.SetKeyPressActivationValue('b');
        this.pw.SetInteractor((vtkRenderWindowInteractor)this.iren);
        this.bw.SetInteractor((vtkRenderWindowInteractor)this.iren);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = vtkCanvas.this.getWidth();
                int n2 = vtkCanvas.this.getHeight();
                vtkCanvas.this.setSize(n, n2);
            }
        });
        this.ren.SetBackground(0.0, 0.0, 0.0);
    }

    public void StartTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void DestroyTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public vtkGenericRenderWindowInteractor getIren() {
        return this.iren;
    }

    public void setInteractorStyle(vtkInteractorStyle vtkInteractorStyle2) {
        this.iren.SetInteractorStyle((vtkInteractorObserver)vtkInteractorStyle2);
    }

    public void addToPlaneWidget(vtkProp3D vtkProp3D2) {
        this.pw.SetProp3D(vtkProp3D2);
        this.pw.PlaceWidget();
    }

    public void addToBoxWidget(vtkProp3D vtkProp3D2) {
        this.bw.SetProp3D(vtkProp3D2);
        this.bw.PlaceWidget();
    }

    public void BeginPlaneInteraction() {
        System.out.println("Plane widget begin interaction");
    }

    public void BeginBoxInteraction() {
        System.out.println("Box widget begin interaction");
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(n, n2);
            this.iren.SetSize(n, n2);
            this.iren.ConfigureEvent();
            this.UnLock();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.Lock();
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.ctrlPressed = (mouseEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.iren.LeftButtonPressEvent();
        } else if ((mouseEvent.getModifiers() & 8) == 8) {
            this.iren.MiddleButtonPressEvent();
        } else if ((mouseEvent.getModifiers() & 4) == 4) {
            this.iren.RightButtonPressEvent();
        }
        this.UnLock();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.rw.SetDesiredUpdateRate(0.01);
        this.ctrlPressed = (mouseEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.Lock();
            this.iren.LeftButtonReleaseEvent();
            this.UnLock();
        }
        if ((mouseEvent.getModifiers() & 8) == 8) {
            this.Lock();
            this.iren.MiddleButtonReleaseEvent();
            this.UnLock();
        }
        if ((mouseEvent.getModifiers() & 4) == 4) {
            this.Lock();
            this.iren.RightButtonReleaseEvent();
            this.UnLock();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), 0, 0, '0', 0, "0");
        this.iren.EnterEvent();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), 0, 0, '0', 0, "0");
        this.iren.LeaveEvent();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.ctrlPressed = (mouseEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.ctrlPressed = (mouseEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (mouseEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(mouseEvent.getX(), mouseEvent.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
        this.UpdateLight();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        char c = keyEvent.getKeyChar();
        this.ctrlPressed = (keyEvent.getModifiers() & 2) == 2 ? 1 : 0;
        this.shiftPressed = (keyEvent.getModifiers() & 1) == 1 ? 1 : 0;
        this.iren.SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, c, 0, String.valueOf(c));
        this.Lock();
        this.iren.KeyPressEvent();
        this.iren.CharEvent();
        this.UnLock();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    static {
        System.loadLibrary("vtkHybridJava");
    }

    private class DelayAction
    implements ActionListener {
        private DelayAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            vtkCanvas.this.Lock();
            vtkCanvas.this.iren.TimerEvent();
            vtkCanvas.this.UpdateLight();
            vtkCanvas.this.UnLock();
        }
    }
}

