/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.probingline;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.probingline.ProbingLinePlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import vtk.vtkDataSet;

public class ProbingLineControlUI
extends JDialog
implements ActionListener {
    private PipeLineManager pipeLineManager;
    private ProbingLinePlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JFormattedTextField aX;
    private JFormattedTextField aY;
    private JFormattedTextField aZ;
    private JFormattedTextField bX;
    private JFormattedTextField bY;
    private JFormattedTextField bZ;
    private JFormattedTextField resolution;
    private JCheckBox viewPlot2D;
    private JRadioButton indexRBut;
    private JRadioButton xRBut;
    private JRadioButton yRBut;
    private JRadioButton zRBut;
    private JRadioButton sRBut;

    public ProbingLineControlUI(PipeLineManager pipeLineManager, ProbingLinePlugin probingLinePlugin, Frame frame) {
        super(frame, "Probe configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = probingLinePlugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), probingLinePlugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener(this);
        jPanel.add((Component)this.inputDataset, "Center");
        jPanel.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(3, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Line definition"));
        this.aX = new JFormattedTextField((Object)"0");
        this.aX.setValue(new Double(0.0));
        this.aY = new JFormattedTextField((Object)"0");
        this.aY.setValue(new Double(0.0));
        this.aZ = new JFormattedTextField((Object)"0");
        this.aZ.setValue(new Double(0.0));
        this.bX = new JFormattedTextField((Object)"10");
        this.bX.setValue(new Double(1.0));
        this.bY = new JFormattedTextField((Object)"10");
        this.bY.setValue(new Double(1.0));
        this.bZ = new JFormattedTextField((Object)"10");
        this.bZ.setValue(new Double(1.0));
        jPanel.add(new JPanel());
        jPanel.add(new JLabel("X", 0));
        jPanel.add(new JLabel("Y", 0));
        jPanel.add(new JLabel("Z", 0));
        jPanel.add(new JLabel("A", 0));
        jPanel.add(this.aX);
        jPanel.add(this.aY);
        jPanel.add(this.aZ);
        jPanel.add(new JLabel("B", 0));
        jPanel.add(this.bX);
        jPanel.add(this.bY);
        jPanel.add(this.bZ);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Resolution"));
        jPanel.add(new JLabel("Resolution"));
        this.resolution = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.resolution.setValue(new Integer(256));
        jPanel.add(this.resolution);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(1, 6));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Plot 2D"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.viewPlot2D = new JCheckBox("View plot", true);
        jPanel.add(this.viewPlot2D);
        this.indexRBut = new JRadioButton("index");
        jPanel.add(this.indexRBut);
        buttonGroup.add(this.indexRBut);
        this.xRBut = new JRadioButton("X");
        jPanel.add(this.xRBut);
        buttonGroup.add(this.xRBut);
        this.yRBut = new JRadioButton("Y");
        jPanel.add(this.yRBut);
        buttonGroup.add(this.yRBut);
        this.zRBut = new JRadioButton("Z");
        jPanel.add(this.zRBut);
        buttonGroup.add(this.zRBut);
        this.sRBut = new JRadioButton("S", true);
        jPanel.add(this.sRBut);
        buttonGroup.add(this.sRBut);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel();
        JButton jButton = new JButton("Export");
        jButton.setActionCommand("EXPORT");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Update");
        jButton2.setActionCommand("UPDATE");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Cancel");
        jButton3.setActionCommand("CANCEL");
        jButton3.addActionListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.getContentPane().add(jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(dimension.width + 100, dimension.height);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        double[] dArray = new double[]{((Number)this.aX.getValue()).doubleValue(), ((Number)this.aY.getValue()).doubleValue(), ((Number)this.aZ.getValue()).doubleValue()};
        double[] dArray2 = new double[]{((Number)this.bX.getValue()).doubleValue(), ((Number)this.bY.getValue()).doubleValue(), ((Number)this.bZ.getValue()).doubleValue()};
        int n = ((Number)this.resolution.getValue()).intValue();
        if (string.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                int n2 = -1;
                if (this.indexRBut.isSelected()) {
                    n2 = 0;
                }
                if (this.xRBut.isSelected()) {
                    n2 = 1;
                }
                if (this.yRBut.isSelected()) {
                    n2 = 2;
                }
                if (this.zRBut.isSelected()) {
                    n2 = 3;
                }
                if (this.sRBut.isSelected()) {
                    n2 = 4;
                }
                this.plugin.updateProbe((vtkDataSet)((VtkObject)this.datasetModel.getSelectedItem()).getVtkObject(), dArray, dArray2, n, this.viewPlot2D.isSelected(), n2);
            }
        } else if (string.equals("CANCEL")) {
            this.dispose();
        } else if (string.equals("EXPORT")) {
            this.plugin.export();
        }
    }
}

