/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.DateRange;
import org.jfree.data.Range;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class DateAxis
extends ValueAxis
implements Cloneable,
Serializable {
    public static final DateRange DEFAULT_DATE_RANGE = new DateRange();
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE_IN_MILLISECONDS = 2.0;
    public static final DateTickUnit DEFAULT_DATE_TICK_UNIT = new DateTickUnit(2, 1, new SimpleDateFormat());
    public static final Date DEFAULT_ANCHOR_DATE = new Date();
    private DateTickUnit tickUnit;
    private DateFormat dateFormatOverride;
    private DateTickMarkPosition tickMarkPosition = DateTickMarkPosition.START;
    private static final Timeline DEFAULT_TIMELINE = new DefaultTimeline();
    private Timeline timeline;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DateAxis) {
            DateAxis dateAxis = (DateAxis)object;
            boolean bl = ObjectUtils.equal(this.tickUnit, dateAxis.tickUnit);
            boolean bl2 = ObjectUtils.equal(this.dateFormatOverride, dateAxis.dateFormatOverride);
            boolean bl3 = ObjectUtils.equal(this.tickMarkPosition, dateAxis.tickMarkPosition);
            boolean bl4 = ObjectUtils.equal(this.timeline, dateAxis.timeline);
            return bl && bl2 && bl3 && bl4;
        }
        return false;
    }

    public DateAxis() {
        this(null);
    }

    public DateAxis(String string) {
        this(string, DEFAULT_TIMELINE);
    }

    public DateAxis(String string, Timeline timeline) {
        super(string, DateAxis.createStandardDateTickUnits());
        this.setTickUnit(DEFAULT_DATE_TICK_UNIT, false, false);
        this.setAutoRangeMinimumSize(2.0);
        this.setRange(DEFAULT_DATE_RANGE, false, false);
        this.dateFormatOverride = null;
        this.timeline = timeline;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void setTimeline(Timeline timeline) {
        if (this.timeline != timeline) {
            this.timeline = timeline;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateTickUnit dateTickUnit) {
        this.setTickUnit(dateTickUnit, true, true);
    }

    public void setTickUnit(DateTickUnit dateTickUnit, boolean bl, boolean bl2) {
        this.tickUnit = dateTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateFormat getDateFormatOverride() {
        return this.dateFormatOverride;
    }

    public void setDateFormatOverride(DateFormat dateFormat) {
        this.dateFormatOverride = dateFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("DateAxis.setRange(...): null not permitted.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        this.setRange(range, true, true);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(Date date, Date date2) {
        if (date.getTime() >= date2.getTime()) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower not before upper.");
        }
        this.setRange(new DateRange(date, date2));
    }

    public void setRange(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower >= upper.");
        }
        this.setRange(new DateRange(d, d2));
    }

    public Date getMinimumDate() {
        Date date = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getLowerDate();
        } else {
            date = new Date((long)range.getLowerBound());
        }
        return date;
    }

    public void setMinimumDate(Date date) {
        this.setRange(new DateRange(date, this.getMaximumDate()), true, false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getMaximumDate() {
        Date date = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getUpperDate();
        } else {
            date = new Date((long)range.getUpperBound());
        }
        return date;
    }

    public void setMaximumDate(Date date) {
        this.setRange(new DateRange(this.getMinimumDate(), date), true, false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public DateTickMarkPosition getTickMarkPosition() {
        return this.tickMarkPosition;
    }

    public void setTickMarkPosition(DateTickMarkPosition dateTickMarkPosition) {
        this.tickMarkPosition = dateTickMarkPosition;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public boolean isHiddenValue(long l) {
        return !this.timeline.containsDomainValue(l);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        d = this.timeline.toTimelineValue((long)d);
        DateRange dateRange = (DateRange)this.getRange();
        double d2 = this.timeline.toTimelineValue(dateRange.getLowerDate().getTime());
        double d3 = this.timeline.toTimelineValue(dateRange.getUpperDate());
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d5 = rectangle2D.getX();
            double d6 = rectangle2D.getMaxX();
            d4 = this.isInverted() ? d6 + (d - d2) / (d3 - d2) * (d5 - d6) : d5 + (d - d2) / (d3 - d2) * (d6 - d5);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d7 = rectangle2D.getMinY();
            double d8 = rectangle2D.getMaxY();
            d4 = this.isInverted() ? d7 + (d - d2) / (d3 - d2) * (d8 - d7) : d8 - (d - d2) / (d3 - d2) * (d8 - d7);
        }
        return d4;
    }

    public double translateDateToJava2D(Date date, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = date.getTime();
        return this.translateValueToJava2D(d, rectangle2D, rectangleEdge);
    }

    public double translateJava2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        DateRange dateRange = (DateRange)this.getRange();
        double d2 = this.timeline.toTimelineValue(dateRange.getLowerDate());
        double d3 = this.timeline.toTimelineValue(dateRange.getUpperDate());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        double d6 = this.isInverted() ? d3 - (d - d4) / (d5 - d4) * (d3 - d2) : d2 + (d - d4) / (d5 - d4) * (d3 - d2);
        d6 = this.timeline.toTimelineValue((long)d6);
        return d6;
    }

    public Date calculateLowestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.nextStandardDate(this.getMinimumDate(), dateTickUnit);
    }

    public Date calculateHighestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.previousStandardDate(this.getMaximumDate(), dateTickUnit);
    }

    protected Date previousStandardDate(Date date, DateTickUnit dateTickUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = dateTickUnit.getCount();
        int n2 = calendar.get(dateTickUnit.getCalendarField());
        int n3 = n * (n2 / n);
        switch (dateTickUnit.getUnit()) {
            case 6: {
                int n4 = calendar.get(1);
                int n5 = calendar.get(2);
                int n6 = calendar.get(5);
                int n7 = calendar.get(11);
                int n8 = calendar.get(12);
                int n9 = calendar.get(13);
                calendar.set(n4, n5, n6, n7, n8, n9);
                calendar.set(14, n3);
                return calendar.getTime();
            }
            case 5: {
                int n10 = calendar.get(1);
                int n11 = calendar.get(2);
                int n12 = calendar.get(5);
                int n13 = calendar.get(11);
                int n14 = calendar.get(12);
                int n15 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 500 : 999);
                calendar.set(14, n15);
                calendar.set(n10, n11, n12, n13, n14, n3);
                return calendar.getTime();
            }
            case 4: {
                int n16 = calendar.get(1);
                int n17 = calendar.get(2);
                int n18 = calendar.get(5);
                int n19 = calendar.get(11);
                int n20 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 30 : 59);
                calendar.clear(14);
                calendar.set(n16, n17, n18, n19, n3, n20);
                return calendar.getTime();
            }
            case 3: {
                int n21;
                int n22;
                int n23 = calendar.get(1);
                int n24 = calendar.get(2);
                int n25 = calendar.get(5);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n22 = 0;
                    n21 = 0;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n22 = 30;
                    n21 = 0;
                } else {
                    n22 = 59;
                    n21 = 59;
                }
                calendar.clear(14);
                calendar.set(n23, n24, n25, n3, n22, n21);
                return calendar.getTime();
            }
            case 2: {
                int n26;
                int n27 = calendar.get(1);
                int n28 = calendar.get(2);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n26 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n26 = 12;
                    boolean bl = false;
                    boolean bl3 = false;
                } else {
                    n26 = 23;
                    int n29 = 59;
                    int n30 = 59;
                }
                calendar.clear(14);
                calendar.set(n27, n28, n3, n26, 0, 0);
                long l = calendar.getTime().getTime();
                if (l > date.getTime()) {
                    calendar.set(n27, n28, n3 - 1, n26, 0, 0);
                }
                return calendar.getTime();
            }
            case 1: {
                int n31 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n31, n3, 1, 0, 0, 0);
                Month month = new Month(calendar.getTime());
                Date date2 = this.calculateDateForPosition(month, this.tickMarkPosition);
                long l = date2.getTime();
                if (l > date.getTime()) {
                    month = (Month)month.previous();
                    date2 = this.calculateDateForPosition(month, this.tickMarkPosition);
                }
                return date2;
            }
            case 0: {
                int n32 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 6 : 12);
                calendar.clear(14);
                calendar.set(n3, n32, 0, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    private Date calculateDateForPosition(RegularTimePeriod regularTimePeriod, DateTickMarkPosition dateTickMarkPosition) {
        Date date = null;
        if (dateTickMarkPosition == DateTickMarkPosition.START) {
            date = new Date(regularTimePeriod.getFirstMillisecond());
        } else if (dateTickMarkPosition == DateTickMarkPosition.MIDDLE) {
            date = new Date(regularTimePeriod.getMiddleMillisecond());
        } else if (dateTickMarkPosition == DateTickMarkPosition.END) {
            date = new Date(regularTimePeriod.getLastMillisecond());
        }
        return date;
    }

    protected Date nextStandardDate(Date date, DateTickUnit dateTickUnit) {
        Date date2 = this.previousStandardDate(date, dateTickUnit);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(dateTickUnit.getCalendarField(), dateTickUnit.getCount());
        return calendar.getTime();
    }

    public static TickUnitSource createStandardDateTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new DateTickUnit(6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 5, 6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 10, 6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 25, 6, 5, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 50, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 100, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 250, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 500, 6, 50, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(5, 1, 6, 50, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(5, 5, 5, 1, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(5, 10, 5, 1, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(5, 30, 5, 5, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(4, 1, 5, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 2, 5, 10, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 5, 4, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 10, 4, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 15, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 20, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 30, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 1, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 2, 4, 10, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 4, 4, 30, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 6, 3, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 12, 3, 1, new SimpleDateFormat("d-MMM, HH:mm")));
        tickUnits.add(new DateTickUnit(2, 1, 3, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 2, 3, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 7, 2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 15, 2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(1, 1, 2, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(1, 2, 2, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(1, 3, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(1, 4, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(1, 6, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(0, 1, 1, 1, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 2, 1, 3, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 5, 0, 1, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 10, 0, 1, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 25, 0, 5, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 50, 0, 10, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 100, 0, 20, new SimpleDateFormat("yyyy")));
        return tickUnits;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            long l;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = new DateRange();
            }
            long l2 = this.timeline.toTimelineValue((long)range.getUpperBound());
            long l3 = (long)this.getFixedAutoRange();
            if ((double)l3 > 0.0) {
                l = l2 - l3;
            } else {
                long l4;
                l = this.timeline.toTimelineValue((long)range.getLowerBound());
                double d = l2 - l;
                if (d < (double)(l4 = (long)this.getAutoRangeMinimumSize())) {
                    long l5 = (long)((double)l4 - d) / 2L;
                    l2 += l5;
                    l -= l5;
                }
                l2 += (long)(d * this.getUpperMargin());
                l -= (long)(d * this.getLowerMargin());
            }
            l2 = this.timeline.toMillisecond(l2);
            l = this.timeline.toMillisecond(l);
            DateRange dateRange = new DateRange(new Date(l), new Date(l2));
            this.setRange(dateRange, false, false);
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d;
        double d2;
        double d3;
        double d4;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        double d5 = this.translateValueToJava2D(0.0, rectangle2D2, rectangleEdge);
        double d6 = this.getRange().getLength() / 10.0;
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d6);
        double d7 = this.estimateMaximumTickLabelWidth(graphics2D, dateTickUnit);
        double d8 = d7 / (d4 = Math.abs((d3 = this.translateValueToJava2D(dateTickUnit.getSize(), rectangle2D2, rectangleEdge)) - d5)) * dateTickUnit.getSize();
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d8);
        double d9 = this.estimateMaximumTickLabelWidth(graphics2D, dateTickUnit2);
        DateTickUnit dateTickUnit3 = d9 < (d2 = Math.abs((d = this.translateValueToJava2D(dateTickUnit2.getSize(), rectangle2D2, rectangleEdge)) - d5)) ? dateTickUnit2 : (DateTickUnit)tickUnitSource.getLargerTickUnit(dateTickUnit2);
        this.setTickUnit(dateTickUnit3, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d;
        double d2;
        double d3;
        double d4;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        double d5 = this.translateValueToJava2D(0.0, rectangle2D2, rectangleEdge);
        double d6 = this.getRange().getLength() / 10.0;
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d6);
        double d7 = this.estimateMaximumTickLabelHeight(graphics2D, dateTickUnit);
        double d8 = d7 / (d4 = Math.abs((d3 = this.translateValueToJava2D(dateTickUnit.getSize(), rectangle2D2, rectangleEdge)) - d5)) * dateTickUnit.getSize();
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d8);
        double d9 = this.estimateMaximumTickLabelHeight(graphics2D, dateTickUnit2);
        DateTickUnit dateTickUnit3 = d9 < (d2 = Math.abs((d = this.translateValueToJava2D(dateTickUnit2.getSize(), rectangle2D2, rectangleEdge)) - d5)) ? dateTickUnit2 : (DateTickUnit)tickUnitSource.getLargerTickUnit(dateTickUnit2);
        this.setTickUnit(dateTickUnit3, false, false);
    }

    private double estimateMaximumTickLabelWidth(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.left + insets.right;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (this.isVerticalTickLabels()) {
            d += (double)lineMetrics.getHeight();
        } else {
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.getDateFormatOverride();
            if (dateFormat != null) {
                string = dateFormat.format(date);
                string2 = dateFormat.format(date2);
            } else {
                string = dateTickUnit.dateToString(date);
                string2 = dateTickUnit.dateToString(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d2 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            double d3 = fontMetrics.getStringBounds(string2, graphics2D).getWidth();
            d += Math.max(d2, d3);
        }
        return d;
    }

    private double estimateMaximumTickLabelHeight(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.top + insets.bottom;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (!this.isVerticalTickLabels()) {
            d += (double)lineMetrics.getHeight();
        } else {
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.getDateFormatOverride();
            if (dateFormat != null) {
                string = dateFormat.format(date);
                string2 = dateFormat.format(date2);
            } else {
                string = dateTickUnit.dateToString(date);
                string2 = dateTickUnit.dateToString(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d2 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            double d3 = fontMetrics.getStringBounds(string2, graphics2D).getWidth();
            d += Math.max(d2, d3);
        }
        return d;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        }
        return list;
    }

    public List refreshTicksHorizontal(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        block5: while (date.before(date2)) {
            double d2;
            TextAnchor textAnchor;
            TextAnchor textAnchor2;
            float f;
            float f2;
            String string;
            if (!this.isHiddenValue(date.getTime())) {
                double d3 = this.translateDateToJava2D(date, rectangle2D2, rectangleEdge);
                DateFormat dateFormat = this.getDateFormatOverride();
                string = dateFormat != null ? dateFormat.format(date) : this.tickUnit.dateToString(date);
                f2 = (float)d3;
                f = 0.0f;
                textAnchor2 = null;
                textAnchor = null;
                d2 = 0.0;
                Insets insets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    if (rectangleEdge == RectangleEdge.TOP) {
                        f = (float)(d - (double)insets.right);
                        d2 = 1.5707963267948966;
                    } else {
                        f = (float)(d + (double)insets.right);
                        d2 = -1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    f = (float)(d - (double)insets.bottom);
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    f = (float)(d + (double)insets.top);
                    textAnchor2 = TextAnchor.TOP_CENTER;
                    textAnchor = TextAnchor.TOP_CENTER;
                }
            } else {
                date = dateTickUnit.rollDate(date);
                continue;
            }
            DateTick dateTick = new DateTick(date, string, f2, f, textAnchor2, textAnchor, d2);
            arrayList.add(dateTick);
            date = dateTickUnit.addToDate(date);
            switch (dateTickUnit.getUnit()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: {
                    date = this.calculateDateForPosition(new Month(date), this.tickMarkPosition);
                    continue block5;
                }
                case 0: {
                    date = this.calculateDateForPosition(new Year(date), this.tickMarkPosition);
                    continue block5;
                }
            }
        }
        return arrayList;
    }

    public List refreshTicksVertical(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        while (date.before(date2)) {
            if (!this.isHiddenValue(date.getTime())) {
                double d2 = this.translateDateToJava2D(date, rectangle2D2, rectangleEdge);
                String string = this.tickUnit.dateToString(date);
                float f = 0.0f;
                float f2 = (float)d2;
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d3 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    if (rectangleEdge == RectangleEdge.LEFT) {
                        f = (float)(d - (double)this.getTickLabelInsets().bottom);
                        d3 = -1.5707963267948966;
                    } else {
                        f = (float)(d + (double)this.getTickLabelInsets().bottom);
                        d3 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    f = (float)(d - (double)this.getTickLabelInsets().right);
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    f = (float)(d + (double)this.getTickLabelInsets().left);
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                DateTick dateTick = new DateTick(date, string, f, f2, textAnchor, textAnchor2, d3);
                arrayList.add(dateTick);
                date = dateTickUnit.addToDate(date);
                continue;
            }
            date = dateTickUnit.rollDate(date);
        }
        return arrayList;
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    public Object clone() throws CloneNotSupportedException {
        DateAxis dateAxis = (DateAxis)super.clone();
        if (this.dateFormatOverride != null) {
            dateAxis.dateFormatOverride = (DateFormat)this.dateFormatOverride.clone();
        }
        return dateAxis;
    }

    private static class DefaultTimeline
    implements Timeline,
    Serializable {
        private DefaultTimeline() {
        }

        public long toTimelineValue(long l) {
            return l;
        }

        public long toTimelineValue(Date date) {
            return date.getTime();
        }

        public long toMillisecond(long l) {
            return l;
        }

        public boolean containsDomainValue(long l) {
            return true;
        }

        public boolean containsDomainValue(Date date) {
            return true;
        }

        public boolean containsDomainRange(long l, long l2) {
            return true;
        }

        public boolean containsDomainRange(Date date, Date date2) {
            return true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return object instanceof DefaultTimeline;
        }
    }
}

