/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.needle.ArrowNeedle;
import org.jfree.chart.needle.LineNeedle;
import org.jfree.chart.needle.LongNeedle;
import org.jfree.chart.needle.MeterNeedle;
import org.jfree.chart.needle.PinNeedle;
import org.jfree.chart.needle.PlumNeedle;
import org.jfree.chart.needle.PointerNeedle;
import org.jfree.chart.needle.ShipNeedle;
import org.jfree.chart.needle.WindNeedle;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.ValueDataset;
import org.jfree.util.ObjectUtils;

public class CompassPlot
extends Plot
implements Cloneable,
Serializable {
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int labelType;
    private Font labelFont;
    private boolean drawBorder = false;
    private Paint roseHighlightPaint = Color.black;
    private Paint rosePaint = Color.yellow;
    private Paint roseCenterPaint = Color.white;
    private Font compassFont = new Font("Arial", 0, 10);
    private transient Ellipse2D circle1;
    private transient Ellipse2D circle2;
    private transient Area a1;
    private transient Area a2;
    private transient Rectangle2D rect1;
    private ValueDataset[] datasets = new ValueDataset[1];
    private MeterNeedle[] seriesNeedle = new MeterNeedle[1];
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public CompassPlot() {
        this(new DefaultValueDataset());
    }

    public CompassPlot(ValueDataset valueDataset) {
        if (valueDataset != null) {
            this.datasets[0] = valueDataset;
            valueDataset.addChangeListener(this);
        }
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.rect1 = new Rectangle2D.Double();
        this.setSeriesNeedle(0);
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != n) {
            this.labelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public void setSeriesPaint(int n, Paint paint) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setFillPaint(paint);
        }
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setOutlinePaint(paint);
        }
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setOutlineStroke(stroke);
        }
    }

    public void setSeriesNeedle(int n) {
        this.setSeriesNeedle(0, n);
    }

    public void setSeriesNeedle(int n, int n2) {
        switch (n2) {
            case 0: {
                this.setSeriesNeedle(n, new ArrowNeedle(true));
                this.setSeriesPaint(n, Color.red);
                this.seriesNeedle[n].setHighlightPaint(Color.white);
                break;
            }
            case 1: {
                this.setSeriesNeedle(n, new LineNeedle());
                break;
            }
            case 2: {
                this.setSeriesNeedle(n, new LongNeedle());
                break;
            }
            case 3: {
                this.setSeriesNeedle(n, new PinNeedle());
                break;
            }
            case 4: {
                this.setSeriesNeedle(n, new PlumNeedle());
                break;
            }
            case 5: {
                this.setSeriesNeedle(n, new PointerNeedle());
                break;
            }
            case 6: {
                this.setSeriesPaint(n, null);
                this.setSeriesOutlineStroke(n, new BasicStroke(3.0f));
                this.setSeriesNeedle(n, new ShipNeedle());
                break;
            }
            case 7: {
                this.setSeriesPaint(n, Color.blue);
                this.setSeriesNeedle(n, new WindNeedle());
                break;
            }
            case 8: {
                this.setSeriesNeedle(n, new ArrowNeedle(true));
                break;
            }
            default: {
                String string = "CompassPlot.setSeriesNeedle(...): unrecognised type.";
                throw new IllegalArgumentException(string);
            }
        }
    }

    public void setSeriesNeedle(int n, MeterNeedle meterNeedle) {
        if (meterNeedle != null && n < this.seriesNeedle.length) {
            this.seriesNeedle[n] = meterNeedle;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueDataset[] getData() {
        return this.datasets;
    }

    public void addData(ValueDataset valueDataset) {
        this.addData(valueDataset, null);
    }

    public void addData(ValueDataset valueDataset, MeterNeedle meterNeedle) {
        if (valueDataset != null) {
            int n = this.datasets.length + 1;
            ValueDataset[] valueDatasetArray = new ValueDataset[n];
            MeterNeedle[] meterNeedleArray = new MeterNeedle[n];
            n -= 2;
            while (n >= 0) {
                valueDatasetArray[n] = this.datasets[n];
                meterNeedleArray[n] = this.seriesNeedle[n];
                --n;
            }
            n = this.datasets.length;
            valueDatasetArray[n] = valueDataset;
            meterNeedleArray[n] = meterNeedle != null ? meterNeedle : meterNeedleArray[n - 1];
            ValueDataset[] valueDatasetArray2 = this.datasets;
            MeterNeedle[] meterNeedleArray2 = this.seriesNeedle;
            this.datasets = valueDatasetArray;
            this.seriesNeedle = meterNeedleArray;
            --n;
            while (n >= 0) {
                valueDatasetArray2[n] = null;
                meterNeedleArray2[n] = null;
                --n;
            }
            valueDataset.addChangeListener(this);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Shape shape;
        int n;
        double d;
        int n2;
        Insets insets;
        int n3 = 0;
        int n4 = 0;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (this.drawBorder) {
            this.drawBackground(graphics2D, rectangle2D);
        }
        int n5 = (int)(rectangle2D.getWidth() / 2.0);
        int n6 = (int)(rectangle2D.getHeight() / 2.0);
        int n7 = n5;
        if (n6 < n5) {
            n7 = n6;
        }
        int n8 = 2 * --n7;
        this.circle1.setFrame((n5 += (int)rectangle2D.getMinX()) - n7, (n6 += (int)rectangle2D.getMinY()) - n7, n8, n8);
        this.circle2.setFrame(n5 - n7 + 15, n6 - n7 + 15, n8 - 30, n8 - 30);
        graphics2D.setPaint(this.rosePaint);
        this.a1 = new Area(this.circle1);
        this.a2 = new Area(this.circle2);
        this.a1.subtract(this.a2);
        graphics2D.fill(this.a1);
        graphics2D.setPaint(this.roseCenterPaint);
        int n9 = n8 - 30;
        graphics2D.fillOval(n5 - n7 + 15, n6 - n7 + 15, n9, n9);
        graphics2D.setPaint(this.roseHighlightPaint);
        graphics2D.drawOval(n5 - n7, n6 - n7, n8, n8);
        n9 = n8 - 20;
        graphics2D.drawOval(n5 - n7 + 10, n6 - n7 + 10, n9, n9);
        n9 = n8 - 30;
        graphics2D.drawOval(n5 - n7 + 15, n6 - n7 + 15, n9, n9);
        n9 = n8 - 80;
        graphics2D.drawOval(n5 - n7 + 40, n6 - n7 + 40, n9, n9);
        n3 = n7 - 20;
        n4 = n7 - 32;
        for (n2 = 0; n2 < 360; n2 += 15) {
            d = Math.toRadians(n2);
            n9 = n5 - (int)(Math.sin(d) * (double)n4);
            int n10 = n5 - (int)(Math.sin(d) * (double)n3);
            n = n6 - (int)(Math.cos(d) * (double)n4);
            int n11 = n6 - (int)(Math.cos(d) * (double)n3);
            graphics2D.drawLine(n9, n, n10, n11);
        }
        graphics2D.setPaint(this.roseHighlightPaint);
        n4 = n7 - 26;
        n3 = 7;
        for (n2 = 45; n2 < 360; n2 += 90) {
            d = Math.toRadians(n2);
            n9 = n5 - (int)(Math.sin(d) * (double)n4);
            n = n6 - (int)(Math.cos(d) * (double)n4);
            graphics2D.fillOval(n9 - n3, n - n3, 2 * n3, 2 * n3);
        }
        for (n2 = 0; n2 < 360; n2 += 90) {
            d = Math.toRadians(n2);
            n9 = n5 - (int)(Math.sin(d) * (double)n4);
            n = n6 - (int)(Math.cos(d) * (double)n4);
            shape = new Polygon();
            shape.addPoint(n9 - n3, n);
            shape.addPoint(n9, n + n3);
            shape.addPoint(n9 + n3, n);
            shape.addPoint(n9, n - n3);
            graphics2D.fillPolygon((Polygon)shape);
        }
        n4 = n7 - 42;
        Font font = this.getCompassFont(n7);
        graphics2D.setFont(font);
        graphics2D.drawString("N", n5 - 5, n6 - n4 + font.getSize());
        graphics2D.drawString("S", n5 - 5, n6 + n4 - 5);
        graphics2D.drawString("W", n5 - n4 + 5, n6 + 5);
        graphics2D.drawString("E", n5 + n4 - font.getSize(), n6 + 5);
        n = n7 / 2;
        n9 = n7 / 6;
        shape = new Rectangle2D.Double(n5 - n9, n6 - n, 2 * n9, 2 * n);
        int n12 = this.seriesNeedle.length;
        int n13 = 0;
        double d2 = 0.0;
        for (int i = this.datasets.length - 1; i >= 0; --i) {
            ValueDataset valueDataset = this.datasets[i];
            if (valueDataset == null || valueDataset.getValue() == null) continue;
            d2 = valueDataset.getValue().doubleValue() % 360.0;
            n13 = i % n12;
            this.seriesNeedle[n13].draw(graphics2D, (Rectangle2D)shape, d2);
        }
        if (this.drawBorder) {
            this.drawOutline(graphics2D, rectangle2D);
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Compass_Plot");
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void zoom(double d) {
    }

    protected Font getCompassFont(int n) {
        float f = n / 10;
        if (f < 8.0f) {
            f = 8.0f;
        }
        Font font = this.compassFont.deriveFont(f);
        return font;
    }

    public List getLegendItemLabels() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CompassPlot && super.equals(object)) {
            CompassPlot compassPlot = (CompassPlot)object;
            boolean bl = this.labelType == compassPlot.labelType;
            boolean bl2 = ObjectUtils.equal(this.labelFont, compassPlot.labelFont);
            boolean bl3 = this.drawBorder == compassPlot.drawBorder;
            boolean bl4 = ObjectUtils.equal(this.roseHighlightPaint, compassPlot.roseHighlightPaint);
            boolean bl5 = ObjectUtils.equal(this.rosePaint, compassPlot.rosePaint);
            boolean bl6 = ObjectUtils.equal(this.roseCenterPaint, compassPlot.roseCenterPaint);
            boolean bl7 = ObjectUtils.equal(this.compassFont, compassPlot.compassFont);
            boolean bl8 = Arrays.equals(this.seriesNeedle, compassPlot.seriesNeedle);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CompassPlot compassPlot = (CompassPlot)super.clone();
        compassPlot.circle1 = (Ellipse2D)this.circle1.clone();
        compassPlot.circle2 = (Ellipse2D)this.circle2.clone();
        compassPlot.a1 = (Area)this.a1.clone();
        compassPlot.a2 = (Area)this.a2.clone();
        compassPlot.rect1 = (Rectangle2D)this.rect1.clone();
        compassPlot.datasets = (ValueDataset[])this.datasets.clone();
        compassPlot.seriesNeedle = (MeterNeedle[])this.seriesNeedle.clone();
        for (int i = 0; i < this.datasets.length; ++i) {
            if (compassPlot.datasets[i] == null) continue;
            compassPlot.datasets[i].addChangeListener(compassPlot);
        }
        return this.clone();
    }
}

