#
# This module is provided as VTK_USE_FILE by VTKConfig.cmake.  It can
# be INCLUDEd in a project to load the needed compiler and linker
# settings to use VTK.
#

# Load the compiler settings used for VTK.
IF(VTK_BUILD_SETTINGS_FILE)
  INCLUDE(${CMAKE_ROOT}/Modules/CMakeImportBuildSettings.cmake)
  CMAKE_IMPORT_BUILD_SETTINGS(${VTK_BUILD_SETTINGS_FILE})
ENDIF(VTK_BUILD_SETTINGS_FILE)

# Add compiler flags needed to use VTK.
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${VTK_REQUIRED_C_FLAGS}")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${VTK_REQUIRED_CXX_FLAGS}")

# If we find the correct version of Tcl installed then we add the paths.
FIND_PATH(VTK_USE_FILE_DETAIL_TCL_LIBRARY
  tcl83.lib
  [HKEY_LOCAL_MACHINE\\SOFTWARE\\Scriptics\\Tcl\\8.3;Root]/lib
)

IF(VTK_USE_FILE_DETAIL_TCL_LIBRARY)
  SET(VTK_LIBRARY_DIRS ${VTK_LIBRARY_DIRS} ${VTK_USE_FILE_DETAIL_TCL_LIBRARY})
  SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} 
      ${VTK_USE_FILE_DETAIL_TCL_LIBRARY}/../include)
ENDIF(VTK_USE_FILE_DETAIL_TCL_LIBRARY)

SET(VTK_USE_FILE_DETAIL_TCL_LIBRARY "${VTK_USE_FILE_DETAIL_TCL_LIBRARY}" 
    CACHE INTERNAL "")

# If we find the correct version of Python installed then we add the paths.
FIND_PATH(VTK_USE_FILE_DETAIL_PYTHON_LIBRARY
  python21.lib
  [HKEY_LOCAL_MACHINE\\SOFTWARE\\Python\\PythonCore\\2.1\\InstallPath]/libs
)

IF(VTK_USE_FILE_DETAIL_PYTHON_LIBRARY)
  SET(VTK_LIBRARY_DIRS ${VTK_LIBRARY_DIRS} 
      ${VTK_USE_FILE_DETAIL_PYTHON_LIBRARY})
  SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} 
      ${VTK_USE_FILE_DETAIL_PYTHON_LIBRARY}/../include)
ENDIF(VTK_USE_FILE_DETAIL_PYTHON_LIBRARY)

SET(VTK_USE_FILE_DETAIL_PYTHON_LIBRARY "${VTK_USE_FILE_DETAIL_PYTHON_LIBRARY}" 
    CACHE INTERNAL "")


# If we find the correct version of Java installed then we add the paths.
FIND_PATH(VTK_USE_FILE_DETAIL_JAVA_LIBRARY
  jawt.lib
  "[HKEY_LOCAL_MACHINE\\SOFTWARE\\JavaSoft\\Java Development Kit\\1.3;JavaHome]/lib"
)

IF(VTK_USE_FILE_DETAIL_JAVA_LIBRARY)
  SET(VTK_LIBRARY_DIRS ${VTK_LIBRARY_DIRS} 
      ${VTK_USE_FILE_DETAIL_JAVA_LIBRARY})
  SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} 
      ${VTK_USE_FILE_DETAIL_JAVA_LIBRARY}/../include/win32 
      ${VTK_USE_FILE_DETAIL_JAVA_LIBRARY}/../include)
ENDIF(VTK_USE_FILE_DETAIL_JAVA_LIBRARY)

SET(VTK_USE_FILE_DETAIL_JAVA_LIBRARY "${VTK_USE_FILE_DETAIL_JAVA_LIBRARY}" 
    CACHE INTERNAL "")

# Add include directories needed to use VTK.
INCLUDE_DIRECTORIES(${VTK_INCLUDE_DIRS})

# Add link directories needed to use VTK.
LINK_DIRECTORIES(${VTK_LIBRARY_DIRS})

# Import the VTK_LOAD_CMAKE_EXTENSIONS macro.
INCLUDE(${VTK_CMAKE_EXTENSIONS_DIR}/vtkLoadCMakeExtensions.cmake)

# Compile the extensions into the build tree and load them. 
VTK_LOAD_CMAKE_EXTENSIONS(${VTK_CMAKE_EXTENSIONS_DIR}
                          ${PROJECT_BINARY_DIR}/CMakeVTK)
