#-----------------------------------------------------------------------------
#
# VTKConfig.cmake - VTK CMake configuration file for external projects.
#
# This file is configured by VTK and used by the UseVTK.cmake module
# to load VTK's settings for an external project.

SET (VTK_INSTALLED_ROOT "${VTK_DIR}/../..")

# The VTK include file directories.
SET(VTK_INCLUDE_DIRS "${VTK_INSTALLED_ROOT}/include/vtk")

# The VTK library directories.
SET(VTK_LIBRARY_DIRS "${VTK_INSTALLED_ROOT}/lib/vtk")

# The C and C++ flags added by VTK to the cmake-configured flags.
SET(VTK_REQUIRED_C_FLAGS "")
SET(VTK_REQUIRED_CXX_FLAGS "")

# The VTK version number
SET(VTK_MAJOR_VERSION "4")
SET(VTK_MINOR_VERSION "2")
SET(VTK_BUILD_VERSION "0")

# The location of the UseVTK.cmake file.
SET(VTK_USE_FILE "${VTK_INSTALLED_ROOT}/lib/vtk/UseVTK.cmake")

# The build settings file.
SET(VTK_BUILD_SETTINGS_FILE
  "${VTK_INSTALLED_ROOT}/lib/vtk/VTKBuildSettings.cmake")

# CMake extension module directory.
SET(VTK_CMAKE_EXTENSIONS_DIR "${VTK_INSTALLED_ROOT}/lib/vtk/CMake")

# The list of available kits.
SET(VTK_KITS "COMMON;FILTERING;IO;GRAPHICS;IMAGING;RENDERING;HYBRID;PARALLEL")

# The list of available languages.
SET(VTK_LANGUAGES "TCL;PYTHON;JAVA")

# VTK Configuration options.
SET(VTK_BUILD_SHARED_LIBS "ON")
SET(VTK_DEBUG_LEAKS "OFF")
SET(VTK_DISABLE_TK_INIT "")
SET(VTK_HAVE_VG500 "")
SET(VTK_HAVE_VP1000 "")
SET(VTK_USE_MANGLED_MESA "OFF")
SET(VTK_MPIRUN_EXE "")
SET(VTK_MPI_MAX_NUMPROCS "")
SET(VTK_MPI_POSTFLAGS "")
SET(VTK_MPI_PREFLAGS "")
SET(VTK_OPENGL_HAS_OSMESA "OFF")
SET(VTK_USE_64BIT_IDS "OFF")
SET(VTK_USE_ANSI_STDLIB "OFF")
SET(VTK_USE_CARBON "OFF")
SET(VTK_USE_COCOA "OFF")
SET(VTK_USE_HYBRID "ON")
SET(VTK_USE_MATROX_IMAGING "")
SET(VTK_USE_MPI "")
SET(VTK_USE_PARALLEL "ON")
SET(VTK_USE_PATENTED "OFF")
SET(VTK_USE_RENDERING "ON")
SET(VTK_USE_VIDEO_FOR_WINDOWS "")
SET(VTK_USE_VOLUMEPRO "OFF")
SET(VTK_USE_X "0")
SET(VTK_WRAP_JAVA "ON")
SET(VTK_WRAP_PYTHON "ON")
SET(VTK_WRAP_TCL "ON")

# The VTK executable locations.
SET(VTK_TCL_HOME "${VTK_INSTALLED_ROOT}/lib/vtk/tcl")
SET(VTK_JAVA_JAR "${VTK_INSTALLED_ROOT}/lib/vtk/java/vtk.jar")
SET(VTK_PARSE_JAVA_EXE "${VTK_INSTALLED_ROOT}/bin/vtkParseJava.exe")
SET(VTK_WRAP_JAVA_EXE "${VTK_INSTALLED_ROOT}/bin/vtkWrapJava.exe")
SET(VTK_WRAP_PYTHON_EXE "${VTK_INSTALLED_ROOT}/bin/vtkWrapPython.exe")
SET(VTK_WRAP_TCL_EXE "${VTK_INSTALLED_ROOT}/bin/vtkWrapTcl.exe")
SET(VTK_DOXYGEN_HOME "${VTK_INSTALLED_ROOT}/lib/vtk/doxygen")
SET(VTK_TK_INTERNAL_DIR "${VTK_INSTALLED_ROOT}/include/vtk/tkInternals/tk83")

# The VTK test script locations.
SET(VTK_HEADER_TESTING_PY 
  "${VTK_INSTALLED_ROOT}/lib/vtk/testing/HeaderTesting.py")
SET(VTK_FIND_STRING_TCL "${VTK_INSTALLED_ROOT}/lib/vtk/testing/FindString.tcl")
SET(VTK_PRINT_SELF_CHECK_TCL 
  "${VTK_INSTALLED_ROOT}/lib/vtk/testing/PrintSelfCheck.tcl")
SET(VTK_RT_IMAGE_TEST_TCL 
  "${VTK_INSTALLED_ROOT}/lib/vtk/testing/rtImageTest.tcl")
SET(VTK_PRT_IMAGE_TEST_TCL 
  "${VTK_INSTALLED_ROOT}/lib/vtk/testing/prtImageTest.tcl")

# The VTK library dependencies.
IF(NOT VTK_NO_LIBRARY_DEPENDS)
  INCLUDE("${VTK_INSTALLED_ROOT}/lib/vtk/VTKLibraryDepends.cmake")
ENDIF(NOT VTK_NO_LIBRARY_DEPENDS)

