/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.clipping;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.clipping.ClippingPlanePlugin;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import vtk.vtkDataSet;

public class ClippingPlaneControlUI
extends JDialog
implements ActionListener,
ChangeListener {
    private PipeLineManager pipeLineManager;
    private JFormattedTextField centerX;
    private JFormattedTextField centerY;
    private JFormattedTextField centerZ;
    private JFormattedTextField normalX;
    private JFormattedTextField normalY;
    private JFormattedTextField normalZ;
    private JComboBox input;
    private JSlider slider;
    private JCheckBox insideOut;
    private ClippingPlanePlugin plugin;

    public ClippingPlaneControlUI(PipeLineManager pipeLineManager, ClippingPlanePlugin clippingPlanePlugin, Frame frame) {
        super(frame, "Clipping plane configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = clippingPlanePlugin;
        this.input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));
        this.centerX = new JFormattedTextField((Object)"0");
        this.centerX.setValue(new Double(0.0));
        this.centerY = new JFormattedTextField((Object)"0");
        this.centerY.setValue(new Double(0.0));
        this.centerZ = new JFormattedTextField((Object)"0");
        this.centerZ.setValue(new Double(0.0));
        this.normalX = new JFormattedTextField((Object)"0");
        this.normalX.setValue(new Double(0.0));
        this.normalY = new JFormattedTextField((Object)"0");
        this.normalY.setValue(new Double(0.0));
        this.normalZ = new JFormattedTextField((Object)"0");
        this.normalZ.setValue(new Double(1.0));
        JPanel jPanel = new JPanel(new GridLayout(3, 4));
        jPanel.add(new JLabel());
        jPanel.add(new JLabel("X"));
        jPanel.add(new JLabel("Y"));
        jPanel.add(new JLabel("Z"));
        jPanel.add(new JLabel("Center"));
        jPanel.add(this.centerX);
        jPanel.add(this.centerY);
        jPanel.add(this.centerZ);
        jPanel.add(new JLabel("Normal"));
        jPanel.add(this.normalX);
        jPanel.add(this.normalY);
        jPanel.add(this.normalZ);
        JButton jButton = new JButton("Update");
        jButton.setActionCommand("UPDATE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        this.insideOut = new JCheckBox("Inside-Out");
        this.insideOut.setActionCommand("UPDATE");
        this.insideOut.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(new JLabel("Input Dataset"));
        jPanel2.add(this.input);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(this.insideOut);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(-10), new JLabel("-1"));
        hashtable.put(new Integer(10), new JLabel("1"));
        hashtable.put(new Integer(0), new JLabel("0"));
        this.slider = new JSlider(-10, 10, 0);
        this.slider.setMinorTickSpacing(1);
        this.slider.setMajorTickSpacing(10);
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintLabels(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        this.slider.setToolTipText("Translation based on center point with the normal vector has unit");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(jPanel2);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(this.slider);
        this.getContentPane().add(jPanel3);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.setSize(dimension.getWidth() + 100.0, dimension.getHeight());
        this.setSize(dimension);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("UPDATE")) {
            if (this.input.getSelectedItem() == null) {
                return;
            }
            double d = ((Number)this.centerX.getValue()).doubleValue();
            double d2 = ((Number)this.centerY.getValue()).doubleValue();
            double d3 = ((Number)this.centerZ.getValue()).doubleValue();
            double d4 = ((Number)this.normalX.getValue()).doubleValue();
            double d5 = ((Number)this.normalY.getValue()).doubleValue();
            double d6 = ((Number)this.normalZ.getValue()).doubleValue();
            this.plugin.updateClippingPlane(d, d2, d3, d4, d5, d6, (vtkDataSet)((VtkObject)this.input.getSelectedItem()).getVtkObject(), this.insideOut.isSelected());
            this.pipeLineManager.validateViewAndGo();
        }
        if (string.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        double d = (double)this.slider.getValue() / 10.0;
        double d2 = ((Number)this.centerX.getValue()).doubleValue();
        double d3 = ((Number)this.centerY.getValue()).doubleValue();
        double d4 = ((Number)this.centerZ.getValue()).doubleValue();
        double d5 = ((Number)this.normalX.getValue()).doubleValue();
        double d6 = ((Number)this.normalY.getValue()).doubleValue();
        double d7 = ((Number)this.normalZ.getValue()).doubleValue();
        if (this.input.getSelectedItem() != null) {
            this.plugin.updateClippingPlane(d2 + d5 * d, d3 + d6 * d, d4 + d7 * d, d5, d6, d7, (vtkDataSet)((VtkObject)this.input.getSelectedItem()).getVtkObject(), this.insideOut.isSelected());
            this.pipeLineManager.validateViewAndGo();
        }
    }

    class DataSetListModel
    implements ComboBoxModel {
        private VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel vtkObjectListModel) {
            this.datasetModel = vtkObjectListModel;
        }

        public Object getElementAt(int n) {
            return this.datasetModel.getElementAt(n);
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public int getSize() {
            return this.datasetModel.getSize();
        }

        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.datasetModel.addListDataListener(listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.datasetModel.removeListDataListener(listDataListener);
        }
    }
}

