/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.clipping;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.clipping.ClippingPlaneControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkClipDataSet;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkImplicitFunction;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ClippingPlanePlugin
implements CassandraPlugin,
RemoveListener {
    private String name = "Cutting plane";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private int nbUpdate = 0;
    private ClippingPlaneControlUI controlUI;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkPlane plane;
    private vtkClipDataSet planeClip;
    private vtkDataSetMapper cutMapper;
    private vtkActor cutActor;
    private Filter filerImpl;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject filter;

    public ClippingPlanePlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.filerImpl = new FilterImpl();
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.controlUI = new ClippingPlaneControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("Cutting plane menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClippingPlanePlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClippingPlanePlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.plane = new vtkPlane();
        this.plane.SetOrigin(0.0, 0.0, 0.0);
        this.plane.SetNormal(0.0, 0.0, 1.0);
        this.planeClip = new vtkClipDataSet();
        this.planeClip.SetClipFunction((vtkImplicitFunction)this.plane);
        this.cutMapper = new vtkDataSetMapper();
        this.cutMapper.SetInput((vtkDataSet)this.planeClip.GetOutput());
        this.cutActor = new vtkActor();
        this.cutActor.SetMapper((vtkMapper)this.cutMapper);
        this.lookupTable = new vtkLookupTable();
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.cutMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        vtkScalarBarActor vtkScalarBarActor2 = new vtkScalarBarActor();
        vtkScalarBarActor2.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.actor = pipeLineManager.addActor((Object)this.cutActor, "Clipping plane");
        this.mapper = pipeLineManager.addMapper((Object)this.cutMapper, "Clipping plane");
        this.dataset = pipeLineManager.addDataSet((Object)this.planeClip.GetOutput(), "Clipping plane");
        this.filter = pipeLineManager.addFilter(this.filerImpl, "Clipping plane");
        pipeLineManager.addLookupTable(this.lookupTable, "Clipping plane");
        pipeLineManager.setActorVisible(pipeLineManager.addScalarBar(vtkScalarBarActor2, "Clipping plane"), true);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateClippingPlane(double d, double d2, double d3, double d4, double d5, double d6, vtkDataSet vtkDataSet2, boolean bl) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.plane.SetOrigin(d, d2, d3);
        this.plane.SetNormal(d4, d5, d6);
        this.planeClip.SetInput(vtkDataSet2);
        this.planeClip.SetInsideOut(bl ? 1 : 0);
        if (vtkDataSet2.GetPointData().GetScalars() != null && (this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filerImpl.getInputDataSet().clear();
        this.filerImpl.getInputDataSet().add(vtkDataSet2);
        this.filerImpl.getOutputDataSet().clear();
        this.filerImpl.getOutputDataSet().add(this.planeClip.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }
}

