/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.movie;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.movie.MoviePlugin;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MovieControlUI
extends JDialog
implements ActionListener,
ChangeListener {
    private PipeLineManager pipeLineManager;
    private JSlider slider;
    private JLabel currentFileName;
    private JSpinner timeBetweenFrame;
    private Timer timer;
    private MoviePlugin plugin;

    public MovieControlUI(PipeLineManager pipeLineManager, MoviePlugin moviePlugin, Frame frame) {
        super(frame, "Movie player configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = moviePlugin;
        JButton jButton = new JButton("Play");
        jButton.setActionCommand("PLAY");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        this.currentFileName = new JLabel();
        this.timeBetweenFrame = new JSpinner(new SpinnerNumberModel(1000, 1000, 5000, 250));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.slider = new JSlider(0, moviePlugin.getVtkFileList().length - 1);
        this.slider.addChangeListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(this.timeBetweenFrame);
        this.getContentPane().add(this.currentFileName);
        this.getContentPane().add(this.slider);
        this.getContentPane().add(jPanel);
        this.slider.setValue(0);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.setSize(dimension.getWidth() + 100.0, dimension.getHeight());
        this.setSize(dimension);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PLAY")) {
            if (((JButton)actionEvent.getSource()).getText().equals("Play")) {
                ((JButton)actionEvent.getSource()).setText("Stop");
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    public void run() {
                        MovieControlUI.this.slider.setValue((MovieControlUI.this.slider.getValue() + 1) % MovieControlUI.this.slider.getMaximum());
                    }
                }, 0L, ((Number)this.timeBetweenFrame.getValue()).longValue());
            } else {
                ((JButton)actionEvent.getSource()).setText("Play");
                this.timer.cancel();
                this.timer = null;
            }
        }
        if (string.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MovieControlUI.this.currentFileName.setText(MovieControlUI.this.plugin.getVtkFileList()[MovieControlUI.this.slider.getValue()].getName());
                MovieControlUI.this.plugin.updateInputFile(MovieControlUI.this.plugin.getVtkFileList()[MovieControlUI.this.slider.getValue()]);
            }
        });
    }
}

