/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.probingline;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.probingline.Plot2D;
import com.artenum.cassandra.plugin.probingline.ProbingLineControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkLineSource;
import vtk.vtkMapper;
import vtk.vtkProbeFilter;
import vtk.vtkTransformPolyDataFilter;

public class ProbingLinePlugin
implements CassandraPlugin,
RemoveListener {
    private String name = "Probing Line";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private ProbingLineControlUI controlUI;
    private double[] startPt;
    private double[] endPt;
    private int resol = 128;
    private ArrayList x;
    private ArrayList y;
    private Plot2D plot;
    private JFrame plotFrame;
    private vtkLineSource line;
    private vtkDataSetMapper lineMapper;
    private vtkActor lineActor;
    private vtkTransformPolyDataFilter tf;
    private vtkProbeFilter probe;
    private VtkObject dataset;
    private VtkObject filter;
    private VtkObject mapper;
    private VtkObject actor;
    private Filter filerImpl = new FilterImpl();

    public ProbingLinePlugin() {
    }

    public ProbingLinePlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this();
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new ProbingLineControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("Probing line menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProbingLinePlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProbingLinePlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.startPt = new double[3];
        this.startPt[0] = 0.0;
        this.startPt[1] = 0.0;
        this.startPt[2] = 0.0;
        this.endPt = new double[3];
        this.endPt[0] = 10.0;
        this.endPt[1] = 10.0;
        this.endPt[2] = 10.0;
        this.line = new vtkLineSource();
        this.line.SetPoint1(this.startPt[0], this.startPt[1], this.startPt[2]);
        this.line.SetPoint2(this.endPt[0], this.endPt[1], this.endPt[2]);
        this.line.SetResolution(this.resol);
        this.probe = new vtkProbeFilter();
        this.probe.SetInput((vtkDataSet)this.line.GetOutput());
        this.lineMapper = new vtkDataSetMapper();
        this.lineMapper.SetInput(this.probe.GetOutput());
        this.lineActor = new vtkActor();
        this.lineActor.SetMapper((vtkMapper)this.lineMapper);
        this.filerImpl.getOutputDataSet().add(this.probe.GetOutput());
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.plotFrame = new JFrame();
        this.x = new ArrayList();
        this.y = new ArrayList();
        this.plot = new Plot2D(this.x, this.y, "The value", "Probe", "Probe");
        this.plotFrame.getContentPane().add(this.plot.getChartPanel());
        this.plotFrame.setSize(512, 300);
        this.plotFrame.setLocationRelativeTo(null);
        this.actor = pipeLineManager.addActor((Object)this.lineActor, "Probe");
        this.mapper = pipeLineManager.addMapper((Object)this.lineMapper, "Probe");
        this.dataset = pipeLineManager.addDataSet((Object)this.probe.GetOutput(), "Probe");
        this.filter = pipeLineManager.addFilter(this.filerImpl, "Prober");
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
    }

    public void updateProbe(vtkDataSet vtkDataSet2, double[] dArray, double[] dArray2, int n, boolean bl, int n2) {
        if (vtkDataSet2 != null) {
            this.startPt = dArray;
            this.endPt = dArray2;
            this.resol = n;
            this.line.SetPoint1(this.startPt[0], this.startPt[1], this.startPt[2]);
            this.line.SetPoint2(this.endPt[0], this.endPt[1], this.endPt[2]);
            this.line.SetResolution(this.resol);
            this.probe.SetSource(vtkDataSet2);
            this.filerImpl.getInputDataSet().clear();
            this.filerImpl.getInputDataSet().add(vtkDataSet2);
            this.probe.Update();
            this.probe.GetOutput().UpdateData();
            int n3 = this.probe.GetOutput().GetNumberOfPoints();
            this.x.clear();
            this.y.clear();
            Double[] doubleArray = new Double[5];
            for (int i = 0; i < n3; ++i) {
                doubleArray[0] = new Double(i);
                doubleArray[1] = new Double(this.probe.GetOutput().GetPoint(i)[0]);
                doubleArray[2] = new Double(this.probe.GetOutput().GetPoint(i)[1]);
                doubleArray[3] = new Double(this.probe.GetOutput().GetPoint(i)[2]);
                doubleArray[4] = new Double(this.computeS(this.probe.GetOutput().GetPoint(i)[0], this.probe.GetOutput().GetPoint(i)[1], this.probe.GetOutput().GetPoint(i)[2]));
                this.x.add(doubleArray[n2]);
                this.y.add(new Double(this.probe.GetOutput().GetPointData().GetScalars().GetTuple1(i)));
            }
            this.pipelineManager.notifyConnectivityChange(this.filter);
            this.plot.updateCollection(this.x, this.y);
            this.plotFrame.setVisible(bl);
        }
    }

    public void export() {
        File file;
        Double[] doubleArray = new Double[5];
        JFileChooser jFileChooser = new JFileChooser();
        if (0 == jFileChooser.showSaveDialog(this.plotFrame) && (file = jFileChooser.getSelectedFile()) != null) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("# index x y z s value \n");
                int n = this.x.size();
                for (int i = 0; i < n; ++i) {
                    doubleArray[0] = new Double(i);
                    doubleArray[1] = new Double(this.probe.GetOutput().GetPoint(i)[0]);
                    doubleArray[2] = new Double(this.probe.GetOutput().GetPoint(i)[1]);
                    doubleArray[3] = new Double(this.probe.GetOutput().GetPoint(i)[2]);
                    doubleArray[4] = new Double(this.computeS(this.probe.GetOutput().GetPoint(i)[0], this.probe.GetOutput().GetPoint(i)[1], this.probe.GetOutput().GetPoint(i)[2]));
                    fileWriter.write(doubleArray[0] + " " + doubleArray[1] + " " + doubleArray[2] + " " + doubleArray[3] + " " + doubleArray[4] + " " + this.probe.GetOutput().GetPointData().GetScalars().GetTuple1(i) + "\n");
                }
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(this.plotFrame, "Error while trying to export: " + iOException.getMessage());
            }
        }
    }

    public double computeS(double d, double d2, double d3) {
        double d4;
        double d5 = 0.0;
        int n = 0;
        double[] dArray = new double[]{d, d2, d3};
        double[] dArray2 = new double[]{this.endPt[0] - this.startPt[0], this.endPt[1] - this.startPt[1], this.endPt[2] - this.startPt[2]};
        if (dArray2[0] >= dArray2[1]) {
            if (dArray2[0] >= dArray2[2]) {
                d4 = dArray2[0];
                n = 0;
            } else {
                d4 = dArray2[2];
                n = 2;
            }
        } else if (dArray2[1] >= dArray2[2]) {
            d4 = dArray2[1];
            n = 1;
        } else {
            d4 = dArray2[2];
            n = 2;
        }
        d5 = dArray[n] - this.startPt[n] / d4;
        return d5;
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public VtkObject getOutputDataSet() {
        return this.dataset;
    }
}

