/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class CategoryLabelPositions
implements Serializable {
    public static CategoryLabelPositions STANDARD = new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.CENTER, 0.0), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER, 0.0), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER, 0.0));
    public static CategoryLabelPositions UP_90 = new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, -1.5707963267948966), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, -1.5707963267948966), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, -1.5707963267948966));
    public static CategoryLabelPositions DOWN_90 = new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, 1.5707963267948966), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, 1.5707963267948966), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, 1.5707963267948966), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, 1.5707963267948966));
    public static CategoryLabelPositions UP_45 = CategoryLabelPositions.createUpRotationLabelPositions(0.7853981633974483);
    public static CategoryLabelPositions DOWN_45 = CategoryLabelPositions.createDownRotationLabelPositions(0.7853981633974483);
    private CategoryLabelPosition positionForAxisAtTop;
    private CategoryLabelPosition positionForAxisAtBottom;
    private CategoryLabelPosition positionForAxisAtLeft;
    private CategoryLabelPosition positionForAxisAtRight;

    public static CategoryLabelPositions createUpRotationLabelPositions(double d) {
        return new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_LEFT, TextAnchor.BOTTOM_LEFT, -d), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_RIGHT, TextAnchor.TOP_RIGHT, -d), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.BOTTOM_RIGHT, TextAnchor.BOTTOM_RIGHT, -d), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, -d));
    }

    public static CategoryLabelPositions createDownRotationLabelPositions(double d) {
        return new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_RIGHT, TextAnchor.BOTTOM_RIGHT, d), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, d), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.TOP_RIGHT, TextAnchor.TOP_RIGHT, d), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.BOTTOM_LEFT, TextAnchor.BOTTOM_LEFT, d));
    }

    public CategoryLabelPositions() {
        this.positionForAxisAtTop = new CategoryLabelPosition();
        this.positionForAxisAtBottom = new CategoryLabelPosition();
        this.positionForAxisAtLeft = new CategoryLabelPosition();
        this.positionForAxisAtRight = new CategoryLabelPosition();
    }

    public CategoryLabelPositions(CategoryLabelPosition categoryLabelPosition, CategoryLabelPosition categoryLabelPosition2, CategoryLabelPosition categoryLabelPosition3, CategoryLabelPosition categoryLabelPosition4) {
        this.positionForAxisAtTop = categoryLabelPosition;
        this.positionForAxisAtBottom = categoryLabelPosition2;
        this.positionForAxisAtLeft = categoryLabelPosition3;
        this.positionForAxisAtRight = categoryLabelPosition4;
    }

    public CategoryLabelPosition getLabelPosition(RectangleEdge rectangleEdge) {
        CategoryLabelPosition categoryLabelPosition = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            categoryLabelPosition = this.positionForAxisAtTop;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            categoryLabelPosition = this.positionForAxisAtBottom;
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            categoryLabelPosition = this.positionForAxisAtLeft;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            categoryLabelPosition = this.positionForAxisAtRight;
        }
        return categoryLabelPosition;
    }

    public static CategoryLabelPositions replaceTopPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        return new CategoryLabelPositions(categoryLabelPosition, categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT));
    }

    public static CategoryLabelPositions replaceBottomPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        return new CategoryLabelPositions(categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPosition, categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT));
    }

    public static CategoryLabelPositions replaceLeftPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        return new CategoryLabelPositions(categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPosition, categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT));
    }

    public static CategoryLabelPositions replaceRightPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        return new CategoryLabelPositions(categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPosition);
    }
}

