/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import com.artenum.cassandra.plugin.PluginIntegrationManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import vtk.vtkLookupTable;

public class VtkObjectUI2
extends JLabel
implements VtkObjectUI {
    private static final String rootPath = "/com/artenum/cassandra/pipeline/graph/";
    private VtkObject object;
    protected final Dimension size = new Dimension(59, 66);
    protected Point position;
    protected String txt;
    protected ImageIcon glassIcon;
    protected ImageIcon glassIcon2;
    protected ImageIcon icon;
    private final int deltaX = 100;
    private final int deltaY = 80;
    static /* synthetic */ Class class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2;

    public VtkObjectUI2(VtkObject vtkObject) {
        this.object = vtkObject;
        this.position = new Point(10, 10);
        this.txt = vtkObject.getName();
        this.setToolTipText(this.txt);
        if (this.txt.length() > 6) {
            this.txt = this.txt.substring(0, 6);
            this.txt = this.txt + "...";
        }
        switch (vtkObject.getType()) {
            case 1: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/actor.png", "Actor");
                this.glassIcon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/actorEye.png", "Visible");
                this.position.x = 400;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 2: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/mapper.png", "Mapper");
                this.txt = "";
                this.position.x = 300;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 3: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/dataset.png", "DataSet");
                this.position.x = 200;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 4: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/filter.png", "Filter");
                this.position.x = 100;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 5: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/lookuptable.png", "Lookup Table");
                this.glassIcon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/linearLT.png", "Lookup Table");
                this.glassIcon2 = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/logLT.png", "Lookup Table");
                this.position.x = 500;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 6: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/scalarBar.png", "ScalarBar");
                this.glassIcon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/actorEye.png", "Visible");
                this.position.x = 600;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 7: {
                this.icon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/txtActor.png", "Text actor");
                this.glassIcon = VtkObjectUI2.createImageIcon("/com/artenum/cassandra/pipeline/graph/icon/txtActorEye.png", "Visible");
                this.position.x = 700;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
            }
        }
        this.setIcon(this.icon);
    }

    public void setName(String string) {
        this.txt = string;
        this.repaint();
    }

    protected static ImageIcon createImageIcon(String string, String string2) {
        URL uRL = (class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2 == null ? (class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2 = VtkObjectUI2.class$("com.artenum.cassandra.pipeline.graph.VtkObjectUI2")) : class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2).getClassLoader().getResource(string);
        System.out.println("Try to get resource in another way. 1: " + uRL);
        uRL = Thread.currentThread().getClass().getResource(string);
        System.out.println("Try to get resource in another way. 2: " + uRL);
        uRL = (class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2 == null ? (class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2 = VtkObjectUI2.class$("com.artenum.cassandra.pipeline.graph.VtkObjectUI2")) : class$com$artenum$cassandra$pipeline$graph$VtkObjectUI2).getResource(string);
        System.out.println("Try to get resource in another way. 3: " + uRL);
        uRL = Thread.currentThread().getClass().getClassLoader().getResource(string);
        System.out.println("Try to get resource in another way. 4: " + uRL);
        uRL = PluginIntegrationManager.getInstance().getParent().getResource(string);
        System.out.println("Try to get resource in another way. 5: " + uRL);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + uRL);
        return null;
    }

    public void savePosition() {
        this.position = this.getLocation();
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    public void setPosition(Point point) {
        this.position = point;
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    public Point getPosition() {
        return this.position;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if ((this.object.getType() == 1 || this.object.getType() == 6 || this.object.getType() == 7) && this.object.getMetaData().get("ACTOR_VISIBLE") != null) {
            if (((String)this.object.getMetaData().get("ACTOR_VISIBLE")).equals("true")) {
                graphics.drawImage(this.glassIcon.getImage(), 0, 0, this.glassIcon.getImageObserver());
            }
        } else if (this.object.getType() == 5) {
            if (((vtkLookupTable)this.object.getVtkObject()).GetScale() == 0) {
                graphics.drawImage(this.glassIcon.getImage(), 0, 0, this.glassIcon.getImageObserver());
            } else {
                graphics.drawImage(this.glassIcon2.getImage(), 0, 0, this.glassIcon2.getImageObserver());
            }
        }
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(this.txt, graphics);
        int n = (int)(59.0 - rectangle2D.getWidth()) / 2;
        graphics.drawString(this.txt, n, 66);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

