/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.dynamic.load;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.dynamic.load.DynamicLoaderPlugin;
import com.artenum.cassandra.plugin.dynamic.load.FileToolBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class DynamicLoaderControlUI
extends JDialog
implements ActionListener,
ChangeListener,
Observer {
    private PipeLineManager pipeLineManager;
    private JTextField firstFileName;
    private JButton browse;
    private JSpinner step;
    private JCheckBox searchForNextFile;
    private JCheckBox loop;
    private JLabel currentFileName;
    private JSlider slider;
    private JSpinner timeBetweenFrame;
    private JCheckBox play;
    private JCheckBox saveFile;
    private Timer timer;
    private Timer timerSearch;
    private DynamicLoaderPlugin plugin;
    private File currentDirectory;

    public DynamicLoaderControlUI(PipeLineManager pipeLineManager, DynamicLoaderPlugin dynamicLoaderPlugin, Frame frame) {
        super(frame, "Movie maker configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = dynamicLoaderPlugin;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Setup"));
        this.getContentPane().add(jPanel);
        this.firstFileName = new JTextField(((File)dynamicLoaderPlugin.getVtkFileList().get(0)).getAbsolutePath());
        this.browse = new JButton("Browse");
        this.browse.setActionCommand("BROWSE");
        this.browse.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("First file: "));
        jPanel2.add(this.firstFileName);
        jPanel2.add(this.browse);
        jPanel.add(jPanel2);
        this.step = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Step number between files: "));
        jPanel2.add(this.step);
        jPanel.add(jPanel2);
        this.searchForNextFile = new JCheckBox("Search next file");
        this.searchForNextFile.setActionCommand("SEARCH_NEXT");
        this.searchForNextFile.addActionListener(this);
        this.loop = new JCheckBox("Loop");
        this.saveFile = new JCheckBox("Save image");
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Movie"));
        this.getContentPane().add(jPanel);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.currentFileName = new JLabel(((File)dynamicLoaderPlugin.getVtkFileList().get(0)).getName());
        jPanel2.add(new JLabel("Current file: "));
        jPanel2.add(this.currentFileName);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.timeBetweenFrame = new JSpinner(new SpinnerNumberModel(1000, 1000, 5000, 250));
        jPanel2.add(new JLabel("Number of ms between frame: "));
        jPanel2.add(this.timeBetweenFrame);
        jPanel.add(jPanel2);
        this.slider = new JSlider(0, dynamicLoaderPlugin.getVtkFileList().size() - 1);
        this.slider.addChangeListener(this);
        jPanel.add(this.slider);
        this.play = new JCheckBox("Play");
        this.play.setActionCommand("PLAY");
        this.play.addActionListener(this);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.searchForNextFile);
        jPanel2.add(this.loop);
        jPanel2.add(this.play);
        jPanel2.add(this.saveFile);
        jPanel.add(jPanel2);
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(this);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        this.getContentPane().add(jPanel2);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.setSize(dimension.getWidth() + 100.0, dimension.getHeight());
        this.setSize(dimension);
        this.setLocationRelativeTo(null);
        dynamicLoaderPlugin.addObserver(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PLAY")) {
            if (this.play.isSelected()) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    public void run() {
                        if (DynamicLoaderControlUI.this.loop.isSelected() || DynamicLoaderControlUI.this.slider.getValue() + 1 <= DynamicLoaderControlUI.this.slider.getMaximum()) {
                            DynamicLoaderControlUI.this.slider.setValue((DynamicLoaderControlUI.this.slider.getValue() + 1) % (DynamicLoaderControlUI.this.slider.getMaximum() + 1));
                        }
                    }
                }, 0L, ((Number)this.timeBetweenFrame.getValue()).longValue());
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        }
        if (string.equals("CANCEL")) {
            this.dispose();
        }
        if (string.equals("SEARCH_NEXT")) {
            System.out.println("SEARCH_NEXT");
            if (this.searchForNextFile.isSelected()) {
                this.timerSearch = new Timer();
                this.timerSearch.schedule(new TimerTask(){

                    public void run() {
                        DynamicLoaderControlUI.this.searchNextFile();
                    }
                }, 10L, 5000L);
            } else {
                this.timerSearch.cancel();
                this.timerSearch = null;
            }
        }
        if (string.equals("BROWSE")) {
            JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".vtk");
                }

                public String getDescription() {
                    return "Vtk files";
                }
            });
            if (jFileChooser.showOpenDialog(this) != 0) {
                return;
            }
            this.currentDirectory = jFileChooser.getSelectedFile().getParentFile();
            this.firstFileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.plugin.setFirstFile(jFileChooser.getSelectedFile());
        }
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public void searchNextFile() {
        File file = (File)this.plugin.getVtkFileList().get(this.plugin.getVtkFileList().size() - 1);
        ArrayList arrayList = FileToolBox.splitNumbers(file.getName());
        StringBuffer stringBuffer = null;
        int n = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            stringBuffer = (StringBuffer)object.next();
            if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9') {
                arrayList2.add(new Integer(n));
            }
            ++n;
        }
        object = new int[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList2.get(i);
        }
        File file2 = null;
        for (int i = 1; i <= 10; ++i) {
            for (int j = 0; j < ((Object)object).length; ++j) {
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int k = 0; k < arrayList.size(); ++k) {
                    if (k == object[j]) {
                        int n2 = ((StringBuffer)arrayList.get(k)).length();
                        String string = Integer.toString(Integer.parseInt(((StringBuffer)arrayList.get(k)).toString()) + ((Number)this.step.getValue()).intValue() * i);
                        if (string.length() < n2) {
                            for (int i2 = 0; i2 < n2 - string.length(); ++i2) {
                                stringBuffer2.append("0");
                            }
                        }
                        stringBuffer2.append(string);
                        continue;
                    }
                    stringBuffer2.append((StringBuffer)arrayList.get(k));
                }
                file2 = new File(file.getParentFile(), stringBuffer2.toString());
                if (!file2.exists()) continue;
                this.plugin.addVtkFile(file2);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File file = (File)DynamicLoaderControlUI.this.plugin.getVtkFileList().get(DynamicLoaderControlUI.this.slider.getValue());
                DynamicLoaderControlUI.this.currentFileName.setText(file.getName());
                DynamicLoaderControlUI.this.plugin.updateInputFile(file, DynamicLoaderControlUI.this.saveFile.isSelected());
            }
        });
    }

    public boolean isSaveFileSelected() {
        return this.saveFile.isSelected();
    }

    public void update(Observable observable, Object object) {
        if (this.slider.getValue() > this.plugin.getVtkFileList().size() - 1) {
            this.slider.setValue(this.plugin.getVtkFileList().size() - 1);
        }
        this.slider.setMaximum(this.plugin.getVtkFileList().size() - 1);
    }
}

