/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.dynamic.load;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.dynamic.load.DynamicLoaderControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class DynamicLoaderPlugin
extends Observable
implements CassandraPlugin,
RemoveListener {
    private String name = "Movie plugin";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private DynamicLoaderControlUI controlUI;
    private vtkDataSetReader dataSetVTK;
    private vtkDataSetMapper mapperVTK;
    private vtkActor actorVTK;
    private vtkLookupTable lookupTableVTK;
    private vtkScalarBarActor scalarBarVTK;
    private Filter filerImpl;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject filter;
    private ArrayList fileList;
    private File currentFile;

    public DynamicLoaderPlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.filerImpl = new FilterImpl();
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.fileList = new ArrayList();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".vtk");
            }

            public String getDescription() {
                return "Vtk files";
            }
        });
        if (jFileChooser.showOpenDialog(frame) != 0) {
            return;
        }
        this.fileList.add(jFileChooser.getSelectedFile());
        this.dataSetVTK = new vtkDataSetReader();
        this.dataSetVTK.SetFileName(((File)this.fileList.get(0)).getAbsolutePath());
        this.dataSetVTK.Update();
        this.mapperVTK = new vtkDataSetMapper();
        this.mapperVTK.SetInput(this.dataSetVTK.GetOutput());
        this.mapperVTK.Update();
        this.actorVTK = new vtkActor();
        this.actorVTK.SetMapper((vtkMapper)this.mapperVTK);
        pipeLineManager.addDataSet((Object)this.dataSetVTK.GetOutput(), "Dynamic");
        pipeLineManager.addMapper((Object)this.mapperVTK, "");
        pipeLineManager.setActorVisible(pipeLineManager.addActor((Object)this.actorVTK, "Dynamic"), true);
        if (this.dataSetVTK.GetOutput().GetScalarRange() != null) {
            this.lookupTableVTK = new vtkLookupTable();
            this.lookupTableVTK.SetHueRange(0.66667, 0.0);
            this.lookupTableVTK.SetTableRange(this.dataSetVTK.GetOutput().GetScalarRange());
            this.lookupTableVTK.Build();
            this.mapperVTK.SetLookupTable((vtkScalarsToColors)this.lookupTableVTK);
            this.mapperVTK.SetScalarRange(this.dataSetVTK.GetOutput().GetScalarRange());
            this.scalarBarVTK = new vtkScalarBarActor();
            this.scalarBarVTK.SetLookupTable((vtkScalarsToColors)this.lookupTableVTK);
            pipeLineManager.addLookupTable(this.lookupTableVTK, "Dynamic");
            pipeLineManager.setActorVisible(pipeLineManager.addScalarBar(this.scalarBarVTK, "Dynamic"), true);
        }
        this.filter = pipeLineManager.addFilter(this.filerImpl, "Dynamic file loader");
        this.filerImpl.getOutputDataSet().add(this.dataSetVTK.GetOutput());
        pipeLineManager.notifyConnectivityChange(this.filter);
        this.controlUI = new DynamicLoaderControlUI(pipeLineManager, this, frame);
        this.controlUI.setCurrentDirectory(jFileChooser.getSelectedFile().getParentFile());
        this.contextualMenu = new JPopupMenu("Movie menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DynamicLoaderPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DynamicLoaderPlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
    }

    public ArrayList getVtkFileList() {
        return this.fileList;
    }

    public void showNextFile() {
        File file = null;
        file = this.currentFile != null ? (File)this.getVtkFileList().get((this.fileList.indexOf(this.currentFile) + 1) % this.fileList.size()) : (File)this.getVtkFileList().get(0);
        this.updateInputFile(file, this.controlUI.isSaveFileSelected());
    }

    public void setFirstFile(File file) {
        this.fileList.clear();
        this.fileList.add(file);
        this.updateInputFile(file, this.controlUI.isSaveFileSelected());
        this.setChanged();
        this.notifyObservers();
    }

    public void addVtkFile(File file) {
        this.fileList.add(file);
        this.setChanged();
        this.notifyObservers();
    }

    public void updateInputFile(final File file, final boolean bl) {
        if (!file.exists()) {
            System.out.println("File not exist: " + file);
            return;
        }
        this.currentFile = file;
        this.dataSetVTK.SetFileName(file.getAbsolutePath());
        this.dataSetVTK.Update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DynamicLoaderPlugin.this.pipelineManager.validateView();
                if (bl) {
                    DynamicLoaderPlugin.this.pipelineManager.getCassandraView().HardCopy(file.getAbsolutePath() + ".tiff", 1);
                }
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }
}

