/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.info2d;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.info2d.Info2DControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor2D;
import vtk.vtkDataSet;
import vtk.vtkLabeledDataMapper;
import vtk.vtkMapper2D;

public class Infos2DPlugin
implements CassandraPlugin,
RemoveListener {
    public static final int SHOW_ID = 0;
    public static final int SHOW_DATA_FIELD = 1;
    public static final int SHOW_NORMAL = 2;
    public static final int SHOW_SCALAR = 3;
    public static final int SHOW_TCOORD = 4;
    public static final int SHOW_TENSOR = 5;
    public static final int SHOW_VECTOR = 6;
    private String name = "Info2D";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private Info2DControlUI controlUI;
    private int nbUpdate = 0;
    private vtkDataSet datasetVTK;
    private vtkLabeledDataMapper mapperVTK;
    private vtkActor2D actorVTK;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject filter;
    private Filter filerImpl = new FilterImpl();

    public Infos2DPlugin() {
    }

    public Infos2DPlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this();
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new Info2DControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("2D Info menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Infos2DPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Infos2DPlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.mapperVTK = new vtkLabeledDataMapper();
        this.mapperVTK.SetLabelFormat("%g");
        this.actorVTK = new vtkActor2D();
        this.actorVTK.SetMapper((vtkMapper2D)this.mapperVTK);
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.filerImpl.getOutputActor().add(this.actorVTK);
        this.actor = pipeLineManager.addActor((Object)this.actorVTK, "Info 2D");
        this.filter = pipeLineManager.addFilter(this.filerImpl, "Info 2D");
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateInfo2D(vtkDataSet vtkDataSet2, int n) {
        if (vtkDataSet2 != null) {
            this.filerImpl.getInputDataSet().clear();
            this.filerImpl.getInputDataSet().add(vtkDataSet2);
            if (this.datasetVTK == null || !this.datasetVTK.equals(vtkDataSet2)) {
                this.datasetVTK = vtkDataSet2;
                this.mapperVTK.SetInput(this.datasetVTK);
            }
            switch (n) {
                case 0: {
                    this.mapperVTK.SetLabelModeToLabelIds();
                    break;
                }
                case 1: {
                    this.mapperVTK.SetLabelModeToLabelFieldData();
                    break;
                }
                case 2: {
                    this.mapperVTK.SetLabelModeToLabelNormals();
                    break;
                }
                case 3: {
                    this.mapperVTK.SetLabelModeToLabelScalars();
                    break;
                }
                case 4: {
                    this.mapperVTK.SetLabelModeToLabelTCoords();
                    break;
                }
                case 5: {
                    this.mapperVTK.SetLabelModeToLabelTensors();
                    break;
                }
                case 6: {
                    this.mapperVTK.SetLabelModeToLabelVectors();
                }
            }
            if (this.mapperVTK.GetInput().equals(this.datasetVTK) && this.pipelineManager.getActorList().getData().contains(this.actor)) {
                this.actor.setValide(true);
                this.pipelineManager.setActorVisible(this.actor, true);
            }
            this.pipelineManager.notifyConnectivityChange(this.filter);
        }
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public VtkObject getOutputDataSet() {
        return this.dataset;
    }
}

