/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.date.SerialDate;

public class DateChooserPanel
extends JPanel
implements ActionListener {
    private Calendar chosenDate = null;
    private Color chosenDateButtonColor = Color.red;
    private Color chosenMonthButtonColor = Color.lightGray;
    private Color chosenOtherButtonColor = Color.darkGray;
    private int firstDayOfWeek = 1;
    private int yearSelectionRange = 20;
    private Font dateFont = new Font("SansSerif", 0, 10);
    private JComboBox monthSelector = null;
    private JComboBox yearSelector = null;
    private JButton todayButton = null;
    private JButton[] buttons = null;
    private boolean refreshing = false;

    public DateChooserPanel() {
        this(Calendar.getInstance(), false);
    }

    public DateChooserPanel(Calendar calendar, boolean bl) {
        super(new BorderLayout());
        this.add((Component)this.constructSelectionPanel(), "North");
        this.add((Component)this.getCalendarPanel(), "Center");
        if (bl) {
            this.add((Component)this.constructControlPanel(), "South");
        }
        this.chosenDate = calendar;
        this.setDate(calendar.getTime());
    }

    public void setDate(Date date) {
        this.chosenDate.setTime(date);
        this.monthSelector.setSelectedIndex(this.chosenDate.get(2));
        this.refreshYearSelector();
        this.refreshButtons();
    }

    public Date getDate() {
        return this.chosenDate.getTime();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = null;
        Integer n = null;
        if (actionEvent.getActionCommand().equals("monthSelectionChanged")) {
            jComboBox = (JComboBox)actionEvent.getSource();
            this.chosenDate.set(2, jComboBox.getSelectedIndex());
            this.refreshButtons();
        }
        if (actionEvent.getActionCommand().equals("yearSelectionChanged") && !this.refreshing) {
            jComboBox = (JComboBox)actionEvent.getSource();
            n = (Integer)jComboBox.getSelectedItem();
            this.chosenDate.set(1, n);
            this.refreshYearSelector();
            this.refreshButtons();
        }
        if (actionEvent.getActionCommand().equals("todayButtonClicked")) {
            this.setDate(new Date());
        }
        if (actionEvent.getActionCommand().equals("dateButtonClicked")) {
            JButton jButton = null;
            jButton = (JButton)actionEvent.getSource();
            int n2 = Integer.parseInt(jButton.getName());
            Calendar calendar = this.getFirstVisibleDate();
            calendar.add(5, n2);
            this.setDate(calendar.getTime());
        }
    }

    private JPanel getCalendarPanel() {
        JPanel jPanel = null;
        JButton jButton = null;
        jPanel = new JPanel(new GridLayout(7, 7));
        jPanel.add(new JLabel("Sun", 0));
        jPanel.add(new JLabel("Mon", 0));
        jPanel.add(new JLabel("Tue", 0));
        jPanel.add(new JLabel("Wed", 0));
        jPanel.add(new JLabel("Thu", 0));
        jPanel.add(new JLabel("Fri", 0));
        jPanel.add(new JLabel("Sat", 0));
        this.buttons = new JButton[42];
        for (int i = 0; i < 42; ++i) {
            jButton = new JButton("");
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.setName(new Integer(i).toString());
            jButton.setFont(this.dateFont);
            jButton.setFocusPainted(false);
            jButton.setActionCommand("dateButtonClicked");
            jButton.addActionListener(this);
            this.buttons[i] = jButton;
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private Color getButtonColor(Calendar calendar) {
        if (this.equalDates(calendar, this.chosenDate)) {
            return this.chosenDateButtonColor;
        }
        if (calendar.get(2) == this.chosenDate.get(2)) {
            return this.chosenMonthButtonColor;
        }
        return this.chosenOtherButtonColor;
    }

    private boolean equalDates(Calendar calendar, Calendar calendar2) {
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    private Calendar getFirstVisibleDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.chosenDate.get(1), this.chosenDate.get(2), 1);
        calendar.add(5, -1);
        while (calendar.get(7) != this.getFirstDayOfWeek()) {
            calendar.add(5, -1);
        }
        return calendar;
    }

    private int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private void refreshButtons() {
        JButton jButton = null;
        Calendar calendar = this.getFirstVisibleDate();
        for (int i = 0; i < 42; ++i) {
            jButton = this.buttons[i];
            jButton.setText(new Integer(calendar.get(5)).toString());
            jButton.setBackground(this.getButtonColor(calendar));
            calendar.add(5, 1);
        }
    }

    private void refreshYearSelector() {
        if (!this.refreshing) {
            this.refreshing = true;
            this.yearSelector.removeAllItems();
            Vector vector = this.getYears(this.chosenDate.get(1));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.yearSelector.addItem(enumeration.nextElement());
            }
            this.yearSelector.setSelectedItem(new Integer(this.chosenDate.get(1)));
            this.refreshing = false;
        }
    }

    private Vector getYears(int n) {
        Vector<Integer> vector = null;
        vector = new Vector<Integer>();
        for (int i = n - this.yearSelectionRange; i <= n + this.yearSelectionRange; ++i) {
            vector.addElement(new Integer(i));
        }
        return vector;
    }

    private JPanel constructSelectionPanel() {
        JPanel jPanel = null;
        jPanel = new JPanel();
        this.monthSelector = new JComboBox<String>(SerialDate.getMonths());
        this.monthSelector.addActionListener(this);
        this.monthSelector.setActionCommand("monthSelectionChanged");
        jPanel.add(this.monthSelector);
        this.yearSelector = new JComboBox(this.getYears(0));
        this.yearSelector.addActionListener(this);
        this.yearSelector.setActionCommand("yearSelectionChanged");
        jPanel.add(this.yearSelector);
        return jPanel;
    }

    private JPanel constructControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.todayButton = new JButton("Today");
        this.todayButton.addActionListener(this);
        this.todayButton.setActionCommand("todayButtonClicked");
        jPanel.add(this.todayButton);
        return jPanel;
    }
}

