/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole;

import com.artenum.jyconsole.AutoScrollable;
import com.artenum.jyconsole.HistoryManager;
import com.artenum.jyconsole.action.DefaultClearAction;
import com.artenum.jyconsole.action.DefaultCompletionAction;
import com.artenum.jyconsole.action.DefaultEscapeAction;
import com.artenum.jyconsole.action.DefaultHistoryNavigationAction;
import com.artenum.jyconsole.action.DefaultValidationAction;
import com.artenum.jyconsole.io.InteractiveCommandLine;
import com.artenum.jyconsole.io.SingleThreadStream;
import com.artenum.jyconsole.io.StyledDocumentOutputStream;
import com.artenum.jyconsole.listener.FocusMouseListener;
import com.artenum.jyconsole.python.JInteractiveInterpreter;
import com.artenum.jyconsole.ui.MiniTextPane;
import com.artenum.jyconsole.ui.PopupMenu;
import com.artenum.jyconsole.ui.Prompt;
import com.artenum.jyconsole.ui.ScrollingView;
import com.artenum.util.PropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.python.core.PyObject;

public class JyConsole
extends JPanel
implements ComponentListener,
AutoScrollable {
    public static final String HEADER = "JyConsole by Artenum, http://www.artenum.com\nType \"copyright\", \"credits\" or \"license\" for more information.\n";
    public static final String COPYRIGHT = "\nCopyright (c) 2005, Artenum SARL \nAllRights reserved.\n\nCopyright (c) 2000, Jython Developers\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.All Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.\nAll rights reserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.\n";
    public static final String LICENSE = "\nJyConsole follows the QPL License. (http://www.trolltech.com/licenses/qpl.html)\n";
    public static final String CREDITS = "\nJyConsole is maintained by the Artenum developers (www.artenum.com).\n";
    public static final String PREF_FILE_PATH = "jyconsole.pref.file.path";
    public static final String PREF_SCRIPT_DIR = "jyconsole.pref.script.dir";
    public static final String PREF_ERROR_TXT_COLOR = "jyconsole.pref.txt.color.error";
    public static final String PREF_NORMAL_TXT_COLOR = "jyconsole.pref.txt.color.normal";
    public static final String PREF_WARNING_TXT_COLOR = "jyconsole.pref.txt.color.warning";
    public static final String PREF_BG_COLOR = "jyconsole.pref.bg.color";
    public static final String STYLE_NORMAL = "default";
    public static final String STYLE_WARNING = "warning";
    public static final String STYLE_ERROR = "error";
    private String interpreterThreadName;
    private JInteractiveInterpreter pythonInterpreter;
    private InteractiveCommandLine cmd;
    private HistoryManager historyManager;
    private Thread currentThread;
    private Hashtable preference;
    private JTextPane archiveUI;
    private StyledDocument archiveModel;
    private JTextPane cmdUI;
    private StyledDocument cmdModel;
    private Prompt prompt;
    private JScrollPane scroll;
    private JPanel uiContent = new ScrollingView(new BorderLayout());
    private PopupMenu popup;
    private FocusMouseListener focusGrabber;

    public JyConsole() {
        this((PyObject)null);
    }

    public JyConsole(PyObject pyObject) {
        super(new BorderLayout());
        Object object;
        Object object2;
        this.archiveModel = new DefaultStyledDocument();
        this.cmdModel = new DefaultStyledDocument();
        this.archiveUI = new MiniTextPane(this.archiveModel);
        this.archiveUI.setEditable(false);
        this.cmdUI = new JTextPane(this.cmdModel);
        this.prompt = new Prompt(this.cmdUI);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.prompt, "West");
        jPanel.add((Component)this.cmdUI, "Center");
        this.uiContent.add((Component)this.archiveUI, "North");
        this.uiContent.add((Component)jPanel, "Center");
        this.uiContent.addComponentListener(this);
        Style style = StyleContext.getDefaultStyleContext().getStyle(STYLE_NORMAL);
        Style style2 = this.archiveUI.addStyle(STYLE_NORMAL, style);
        this.cmdUI.addStyle(STYLE_NORMAL, style);
        Style style3 = this.archiveUI.addStyle(STYLE_WARNING, style2);
        style3 = this.cmdUI.addStyle(STYLE_WARNING, style2);
        style3 = this.archiveUI.addStyle(STYLE_ERROR, style2);
        style3 = this.cmdUI.addStyle(STYLE_ERROR, style2);
        this.scroll = new JScrollPane(this.uiContent);
        this.add((Component)this.scroll, "Center");
        this.preference = new Hashtable();
        if (System.getProperty(PREF_SCRIPT_DIR) != null) {
            this.preference.put(PREF_SCRIPT_DIR, System.getProperty(PREF_SCRIPT_DIR));
        } else {
            this.preference.put(PREF_SCRIPT_DIR, new File(".").getAbsolutePath());
        }
        if (System.getProperty(PREF_ERROR_TXT_COLOR) != null) {
            this.preference.put(PREF_ERROR_TXT_COLOR, Color.decode(System.getProperty(PREF_ERROR_TXT_COLOR)));
        } else {
            this.preference.put(PREF_ERROR_TXT_COLOR, Color.RED);
        }
        if (System.getProperty(PREF_WARNING_TXT_COLOR) != null) {
            this.preference.put(PREF_WARNING_TXT_COLOR, Color.decode(System.getProperty(PREF_WARNING_TXT_COLOR)));
        } else {
            this.preference.put(PREF_WARNING_TXT_COLOR, Color.GREEN);
        }
        if (System.getProperty(PREF_NORMAL_TXT_COLOR) != null) {
            this.preference.put(PREF_NORMAL_TXT_COLOR, Color.decode(System.getProperty(PREF_NORMAL_TXT_COLOR)));
        } else {
            this.preference.put(PREF_NORMAL_TXT_COLOR, Color.BLACK);
        }
        if (System.getProperty(PREF_BG_COLOR) != null) {
            this.preference.put(PREF_BG_COLOR, Color.decode(System.getProperty(PREF_BG_COLOR)));
        } else {
            this.preference.put(PREF_BG_COLOR, Color.WHITE);
        }
        if (System.getProperty(PREF_FILE_PATH) != null) {
            this.preference.put(PREF_FILE_PATH, System.getProperty(PREF_FILE_PATH));
            try {
                object2 = new FileInputStream(System.getProperty(PREF_FILE_PATH));
                try {
                    object = new ObjectInputStream((InputStream)object2);
                    Hashtable hashtable = (Hashtable)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                    this.preference.putAll(hashtable);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    object = new FileOutputStream(System.getProperty(PREF_FILE_PATH));
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                    objectOutputStream.writeObject(this.preference);
                    objectOutputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    fileNotFoundException2.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            this.preference.put(PREF_FILE_PATH, "./pref.data");
        }
        this.cmd = new InteractiveCommandLine(this.cmdModel, this.cmdUI, this.prompt, STYLE_NORMAL);
        this.interpreterThreadName = new String("JyConsole-" + System.currentTimeMillis());
        this.pythonInterpreter = new JInteractiveInterpreter(false);
        if (pyObject != null) {
            this.pythonInterpreter.setLocals(pyObject);
        }
        this.pythonInterpreter.addOut(new SingleThreadStream(new StyledDocumentOutputStream(this.archiveModel, STYLE_NORMAL), this.interpreterThreadName));
        this.pythonInterpreter.addErr(new SingleThreadStream(new StyledDocumentOutputStream(this.archiveModel, STYLE_ERROR), this.interpreterThreadName));
        this.historyManager = new HistoryManager(this);
        object2 = this.cmdUI.getInputMap();
        object = this.cmdUI.getActionMap();
        ((InputMap)object2).put(KeyStroke.getKeyStroke(10, 0), "EXECUTE_COMMAND");
        ((InputMap)object2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_COMMAND");
        ((InputMap)object2).put(KeyStroke.getKeyStroke(38, 0), "UP_COMMAND");
        ((InputMap)object2).put(KeyStroke.getKeyStroke(40, 0), "DOWN_COMMAND");
        ((InputMap)object2).put(KeyStroke.getKeyStroke(32, 2), "COMPLETION_COMMAND");
        ((InputMap)object2).put(KeyStroke.getKeyStroke(76, 2), "CLEAR_COMMAND");
        ((ActionMap)object).put("EXECUTE_COMMAND", new DefaultValidationAction(this));
        ((ActionMap)object).put("ESCAPE_COMMAND", new DefaultEscapeAction(this));
        ((ActionMap)object).put("UP_COMMAND", new DefaultHistoryNavigationAction(this, 1));
        ((ActionMap)object).put("DOWN_COMMAND", new DefaultHistoryNavigationAction(this, 2));
        ((ActionMap)object).put("COMPLETION_COMMAND", new DefaultCompletionAction(this));
        ((ActionMap)object).put("CLEAR_COMMAND", new DefaultClearAction(this));
        this.applyPreferences();
        this.popup = new PopupMenu(this);
        this.cmdUI.addMouseListener(this.popup);
        this.archiveUI.addMouseListener(this.popup);
        this.prompt.addMouseListener(this.popup);
        this.focusGrabber = new FocusMouseListener(this.cmdUI, this);
        this.prompt.addMouseListener(this.focusGrabber);
        this.archiveUI.addMouseListener(this.focusGrabber);
        this.clear();
    }

    public static void main(String[] stringArray) {
        try {
            PropertyLoader.loadProperties((String)"./config.properties");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        JyConsole jyConsole = new JyConsole();
        JFrame jFrame = new JFrame("JyConsole by Artenum");
        jFrame.getContentPane().add((Component)jyConsole, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(600, 400);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public void applyPreferences() {
        this.setColor((Color)this.preference.get(PREF_NORMAL_TXT_COLOR), (Color)this.preference.get(PREF_BG_COLOR));
        this.setColorToStyle(STYLE_ERROR, (Color)this.preference.get(PREF_ERROR_TXT_COLOR));
        this.setColorToStyle(STYLE_WARNING, (Color)this.preference.get(PREF_WARNING_TXT_COLOR));
    }

    public void savePreferences() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((String)this.preference.get(PREF_FILE_PATH));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.preference);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Hashtable getPreferences() {
        return this.preference;
    }

    public Point getCompletionWindowLocation() {
        Point point = this.getInteractiveCommandLine().getCaretPositionPoint();
        Container container = this.cmdUI;
        for (container = container.getParent(); container != null; container = container.getParent()) {
            Point point2 = container.getLocation();
            point.translate(point2.x, point2.y);
        }
        point.x += this.prompt.getWidth();
        return point;
    }

    public InteractiveCommandLine getInteractiveCommandLine() {
        return this.cmd;
    }

    public void showPreviousCmdInHistory() {
        this.historyManager.showPreviousCommand();
        this.prompt.updateLineView();
    }

    public void showNextCmdInHistory() {
        this.historyManager.showNextCommand();
        this.prompt.updateLineView();
    }

    public void executeCmdLine() {
        this.cmdUI.setCaretPosition(0);
        try {
            String string = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(string);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + string.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.runPythonCmd(string);
            this.getInteractiveCommandLine().reset();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.prompt.updateLineView();
    }

    public void executePythonFile(final File file) {
        this.currentThread = new Thread(new Runnable(){

            public void run() {
                JyConsole.this.pythonInterpreter.execfile(file.getAbsolutePath());
            }
        }, this.interpreterThreadName);
        this.currentThread.start();
    }

    private void runPythonCmd(final String string) {
        this.currentThread = new Thread(new Runnable(){

            public void run() {
                JyConsole.this.pythonInterpreter.runsource(string);
            }
        }, this.interpreterThreadName);
        this.currentThread.start();
    }

    public void killCurrentThread() {
        if (this.currentThread != null && this.currentThread.isAlive()) {
            this.currentThread.interrupt();
        }
    }

    public void clear() {
        try {
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        try {
            this.archiveModel.remove(0, this.archiveModel.getLength());
            this.archiveModel.insertString(0, HEADER, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void copyright() {
        try {
            String string = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(string);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + string.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        try {
            this.archiveModel.insertString(this.archiveModel.getLength(), COPYRIGHT, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void credits() {
        try {
            String string = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(string);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + string.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        try {
            this.archiveModel.insertString(this.archiveModel.getLength(), CREDITS, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void license() {
        try {
            String string = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(string);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + string.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        try {
            this.archiveModel.insertString(this.archiveModel.getLength(), LICENSE, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public JInteractiveInterpreter getPythonInterpreter() {
        return this.pythonInterpreter;
    }

    public void setColor(Color color, Color color2) {
        this.prompt.setColor(color, color2);
        this.cmdUI.setBackground(color2);
        this.archiveUI.setBackground(color2);
        this.setColorToStyle(STYLE_NORMAL, color);
    }

    public void setColorToStyle(String string, Color color) {
        StyleConstants.setForeground(this.archiveModel.getStyle(string), color);
        StyleConstants.setForeground(this.cmdModel.getStyle(string), color);
    }

    public void setBoldToStyle(String string, boolean bl) {
        StyleConstants.setBold(this.archiveModel.getStyle(string), bl);
        StyleConstants.setBold(this.cmdModel.getStyle(string), bl);
    }

    public void setItalicToStyle(String string, boolean bl) {
        StyleConstants.setItalic(this.archiveModel.getStyle(string), bl);
        StyleConstants.setItalic(this.cmdModel.getStyle(string), bl);
    }

    public void updateScrollPosition() {
        this.scroll.getViewport().setViewPosition(new Point(0, this.uiContent.getHeight() - this.scroll.getViewport().getExtentSize().height));
        this.scroll.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateScrollPosition();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

