/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.vtk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.SwingUtilities;
import vtk.vtkCamera;
import vtk.vtkPanel;

public class CassandraView
extends vtkPanel
implements KeyListener {
    private double zoomFactor = 0.1;
    private boolean deepValidation = true;

    public void setZoomFactor(double d) {
        this.zoomFactor = d;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setXYView() {
        double d = this.ren.GetActiveCamera().GetDistance();
        this.setCameraPosition(0.0, 0.0, d, 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setYZView() {
        this.setCameraPosition(this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0, -90.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setXZView() {
        this.setCameraPosition(0.0, this.ren.GetActiveCamera().GetDistance(), 0.0, -45.0);
        this.UpdateLight();
        this.resetCamera();
    }

    protected void setCameraPosition(double d, double d2, double d3, double d4) {
        this.ren.GetActiveCamera().SetPosition(d, d2, d3);
        this.ren.GetActiveCamera().SetRoll(d4);
    }

    public void setBackground(Color color) {
        double d = (float)color.getRed() / 255.0f;
        double d2 = (float)color.getGreen() / 255.0f;
        double d3 = (float)color.getBlue() / 255.0f;
        this.GetRenderer().SetBackground(d, d2, d3);
    }

    public void setAmbiantLight(Color color) {
        double d = (float)color.getRed() / 255.0f;
        double d2 = (float)color.getGreen() / 255.0f;
        double d3 = (float)color.getBlue() / 255.0f;
        this.GetRenderer().SetAmbient(d, d2, d3);
    }

    public void resetCamera() {
        super.resetCamera();
    }

    public void zoom(double d) {
        vtkCamera vtkCamera2 = this.GetRenderer().GetActiveCamera();
        if (vtkCamera2.GetParallelProjection() == 1) {
            vtkCamera2.SetParallelScale(vtkCamera2.GetParallelScale() / d);
        } else {
            vtkCamera2.Dolly(d);
            this.resetCameraClippingRange();
        }
    }

    public void rotate(double d, double d2) {
        vtkCamera vtkCamera2 = this.GetRenderer().GetActiveCamera();
        vtkCamera2.Azimuth(d);
        vtkCamera2.Elevation(d2);
        vtkCamera2.OrthogonalizeViewUp();
        this.resetCameraClippingRange();
        if (this.LightFollowCamera == 1) {
            this.lgt.SetPosition(vtkCamera2.GetPosition());
            this.lgt.SetFocalPoint(vtkCamera2.GetFocalPoint());
        }
    }

    public void deepValidateView() {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
            this.Render();
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            this.repaint();
        }
        Dimension dimension = this.getPreferredSize();
        if (!this.getSize().equals(dimension)) {
            this.setSize(1, 1);
            this.setSize(dimension);
            this.invalidate();
            this.validate();
            this.repaint();
        } else if (this.deepValidation) {
            this.deepValidation = false;
            this.setSize(1, 1);
            this.setSize(dimension);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void validateViewAndWait() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                        CassandraView.this.Render();
                        CassandraView.this.invalidate();
                        CassandraView.this.validate();
                        CassandraView.this.repaint();
                    } else {
                        CassandraView.this.repaint();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateViewAndGo() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                        CassandraView.this.Render();
                        CassandraView.this.invalidate();
                        CassandraView.this.validate();
                        CassandraView.this.repaint();
                    } else {
                        CassandraView.this.repaint();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 73) {
            this.zoom(1.0 + this.zoomFactor);
        } else if (keyEvent.getKeyCode() == 79) {
            this.zoom(1.0 - this.zoomFactor);
        } else if (keyEvent.getKeyCode() == 38) {
            this.rotate(0.0, -1.0);
        } else if (keyEvent.getKeyCode() == 40) {
            this.rotate(0.0, 1.0);
        } else if (keyEvent.getKeyCode() == 37) {
            this.rotate(1.0, 0.0);
        } else if (keyEvent.getKeyCode() == 39) {
            this.rotate(-1.0, 0.0);
        } else {
            super.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
    }
}

