/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI2;
import com.artenum.graph.impl.DefaultConnection;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import com.artenum.graph.listener.DragListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class VtkObjectCellAdapter
implements Cell {
    private VtkObject object;
    private boolean selected;
    private VtkObjectUI2 ui;
    protected Object oldGroupDragListener;
    protected ArrayList connectionList;
    protected Object userObject;
    protected Color selectedBorderColor = Color.BLACK;
    protected int selectedBorderSize = 2;

    public VtkObjectCellAdapter(VtkObject vtkObject) {
        this.object = vtkObject;
        this.ui = new VtkObjectUI2(vtkObject);
        new DragListener((Cell)this, (Component)this.ui, (Component)this.ui);
        this.connectionList = new ArrayList();
    }

    public Component getUI() {
        return this.ui;
    }

    public List getConnections() {
        return this.connectionList;
    }

    public Point getConnectionPoint(Connection connection) {
        Rectangle rectangle = connection.getOtherCell((Cell)this).getUI().getBounds();
        Rectangle rectangle2 = this.ui.getBounds();
        double d = rectangle.getCenterX();
        double d2 = rectangle.getCenterY();
        double d3 = rectangle2.getCenterX();
        double d4 = rectangle2.getCenterY();
        Point point = new Point((int)d3, (int)d4);
        if (rectangle2.getMaxX() < d || d < rectangle2.getMinX()) {
            point.x = rectangle2.getMinX() > d ? (int)rectangle2.getMinX() : (int)rectangle2.getMaxX();
        } else if (rectangle2.getMaxY() < d2 || d2 < rectangle2.getMinY()) {
            point.y = rectangle2.getMinY() > d2 ? (int)rectangle2.getMinY() : (int)rectangle2.getMaxY();
        }
        return point;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (this.ui != null && this.ui instanceof JComponent) {
            if (bl) {
                this.ui.setBorder(BorderFactory.createLineBorder(this.selectedBorderColor, this.selectedBorderSize));
            } else {
                this.ui.setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void connectTo(Cell cell) {
        DefaultConnection defaultConnection = new DefaultConnection((Cell)this, cell);
        this.addConnection((Connection)defaultConnection);
        cell.addConnection((Connection)defaultConnection);
    }

    public void addConnection(Connection connection) {
        this.connectionList.add(connection);
    }

    public void addGroupDragListener(Object object) {
        if (this.oldGroupDragListener != null) {
            this.ui.removeMouseListener((MouseListener)this.oldGroupDragListener);
            this.ui.removeMouseMotionListener((MouseMotionListener)this.oldGroupDragListener);
        }
        this.ui.addMouseListener((MouseListener)object);
        this.ui.addMouseMotionListener((MouseMotionListener)object);
        this.oldGroupDragListener = object;
    }

    public void setSelectedBorderColor(Color color) {
        this.selectedBorderColor = color;
    }

    public void setSelectedBorderSize(int n) {
        this.selectedBorderSize = n;
    }

    public VtkObject getVtkObject() {
        return this.object;
    }

    public void savePosition() {
        this.ui.savePosition();
    }

    public Point getPosition() {
        return this.ui.getPosition();
    }
}

