/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkContourFilter;
import vtk.vtkDataSet;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;

public class IsoLevelPipeLine {
    private vtkDataSet dataset;
    private vtkPolyDataMapper mapper;
    private vtkActor actor;
    private double level;
    private boolean normal;
    private vtkContourFilter contour;
    private vtkPolyDataNormals normals;

    public IsoLevelPipeLine(vtkDataSet vtkDataSet2, double d, boolean bl) {
        this.dataset = vtkDataSet2;
        this.level = d;
        this.normal = bl;
        this.contour = new vtkContourFilter();
        this.contour.SetValue(0, d);
        this.contour.SetInput(vtkDataSet2);
        this.normals = new vtkPolyDataNormals();
        this.normals.SetInput(this.contour.GetOutput());
        this.normals.SetFeatureAngle(45.0);
        this.mapper = new vtkPolyDataMapper();
        if (vtkDataSet2.GetPointData().GetScalars() != null) {
            this.mapper.SetScalarRange(vtkDataSet2.GetPointData().GetScalars().GetRange());
        }
        this.mapper.ScalarVisibilityOn();
        this.mapper.ColorByArrayComponent("Magnitude", 0);
        this.setNormal(bl);
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)this.mapper);
        vtkDataSet2.Update();
    }

    public void setNormal(final boolean bl) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (bl) {
                        if (IsoLevelPipeLine.this.normals.GetOutput() != null) {
                            IsoLevelPipeLine.this.mapper.SetInput(IsoLevelPipeLine.this.normals.GetOutput());
                        } else {
                            System.out.println("No data to generate normals for!");
                            IsoLevelPipeLine.this.mapper.SetInput(IsoLevelPipeLine.this.contour.GetOutput());
                        }
                    } else {
                        IsoLevelPipeLine.this.mapper.SetInput(IsoLevelPipeLine.this.contour.GetOutput());
                    }
                    IsoLevelPipeLine.this.dataset.Update();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setLevel(final double d) {
        this.level = d;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    IsoLevelPipeLine.this.contour.SetValue(0, d);
                    IsoLevelPipeLine.this.contour.Update();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updatePipeLine() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    IsoLevelPipeLine.this.dataset.Update();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public vtkDataSet getDataset() {
        return this.dataset;
    }

    public vtkMapper getMapper() {
        return this.mapper;
    }
}

