/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.vtk;

import com.artenum.cassandra.pipeline.PipeLineManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.SwingUtilities;
import vtk.vtkCamera;
import vtk.vtkPanel;

public class CassandraView
extends vtkPanel
implements KeyListener {
    private double zoomFactor = 0.1;
    private boolean deepValidation = true;
    private PipeLineManager pipeLineManager;

    public CassandraView(PipeLineManager pipeLineManager) {
        this.pipeLineManager = pipeLineManager;
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = d;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public synchronized void setXYView() {
        double d = this.ren.GetActiveCamera().GetDistance();
        this.ren.GetActiveCamera().SetPosition(0.0, 0.0, d);
        this.ren.GetActiveCamera().SetRoll(0.0);
        this.setCameraPositionSystem(0.0, 0.0, this.ren.GetActiveCamera().GetDistance(), 0.0);
        this.UpdateLight();
        this.resetCamera();
        this.validateView();
    }

    public synchronized void setYZView() {
        double d = this.ren.GetActiveCamera().GetDistance();
        this.setCameraPositionSystem(this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0, -90.0);
        this.UpdateLight();
        this.resetCamera();
        this.validateView();
    }

    public synchronized void setXZView() {
        this.setCameraPositionSystem(this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0, -45.0);
        this.UpdateLight();
        this.resetCamera();
        this.validateView();
    }

    protected void setCameraPositionSystem(double d, double d2, double d3, double d4) {
        this.ren.GetActiveCamera().SetPosition(d, d2, d3);
        this.ren.GetActiveCamera().SetRoll(d4);
    }

    public synchronized void setBackground(Color color) {
        double d = (float)color.getRed() / 255.0f;
        double d2 = (float)color.getGreen() / 255.0f;
        double d3 = (float)color.getBlue() / 255.0f;
        this.GetRenderer().SetBackground(d, d2, d3);
    }

    public synchronized void setAmbiantLight(Color color) {
        double d = (float)color.getRed() / 255.0f;
        double d2 = (float)color.getGreen() / 255.0f;
        double d3 = (float)color.getBlue() / 255.0f;
        this.GetRenderer().SetAmbient(d, d2, d3);
    }

    public synchronized void resetCamera() {
        super.resetCamera();
        this.validateView();
    }

    public synchronized void zoom(final double d) {
        Runnable runnable = new Runnable(){

            public void run() {
                vtkCamera vtkCamera2 = CassandraView.this.GetRenderer().GetActiveCamera();
                if (vtkCamera2.GetParallelProjection() == 1) {
                    vtkCamera2.SetParallelScale(vtkCamera2.GetParallelScale() / d);
                } else {
                    vtkCamera2.Dolly(d);
                    CassandraView.this.resetCameraClippingRange();
                }
            }
        };
        try {
            if (this.pipeLineManager.isScriptMode()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                Thread thread = new Thread(runnable);
                thread.start();
                thread.join();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.validateView();
    }

    public synchronized void rotate(final double d, final double d2) {
        final CassandraView cassandraView = this;
        Runnable runnable = new Runnable(){

            public void run() {
                vtkCamera vtkCamera2 = CassandraView.this.GetRenderer().GetActiveCamera();
                vtkCamera2.Azimuth(d);
                vtkCamera2.Elevation(d2);
                vtkCamera2.OrthogonalizeViewUp();
                CassandraView.this.resetCameraClippingRange();
                if (cassandraView.LightFollowCamera == 1) {
                    CassandraView.this.lgt.SetPosition(vtkCamera2.GetPosition());
                    CassandraView.this.lgt.SetFocalPoint(vtkCamera2.GetFocalPoint());
                }
            }
        };
        try {
            if (this.pipeLineManager.isScriptMode()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                Thread thread = new Thread(runnable);
                thread.start();
                thread.join();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.validateView();
    }

    public synchronized void validateView() {
        Runnable runnable = new Runnable(){

            public void run() {
                Dimension dimension = CassandraView.this.getPreferredSize();
                if (!CassandraView.this.getSize().equals(dimension)) {
                    CassandraView.this.setSize(1, 1);
                    CassandraView.this.setSize(dimension);
                    CassandraView.this.invalidate();
                    CassandraView.this.validate();
                    CassandraView.this.repaint();
                } else if (CassandraView.this.deepValidation) {
                    CassandraView.this.deepValidation = false;
                    CassandraView.this.setSize(1, 1);
                    CassandraView.this.setSize(dimension);
                    CassandraView.this.invalidate();
                    CassandraView.this.validate();
                    CassandraView.this.repaint();
                }
                if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                    CassandraView.this.Render();
                    CassandraView.this.invalidate();
                    CassandraView.this.validate();
                    CassandraView.this.repaint();
                } else {
                    CassandraView.this.repaint();
                }
            }
        };
        try {
            if (this.pipeLineManager.isScriptMode()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                Thread thread = new Thread(runnable);
                thread.start();
                thread.join();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 73) {
            this.zoom(1.0 + this.zoomFactor);
        } else if (keyEvent.getKeyCode() == 79) {
            this.zoom(1.0 - this.zoomFactor);
        } else if (keyEvent.getKeyCode() == 38) {
            this.rotate(0.0, -1.0);
        } else if (keyEvent.getKeyCode() == 40) {
            this.rotate(0.0, 1.0);
        } else if (keyEvent.getKeyCode() == 37) {
            this.rotate(1.0, 0.0);
        } else if (keyEvent.getKeyCode() == 39) {
            this.rotate(-1.0, 0.0);
        } else {
            super.keyPressed(keyEvent);
        }
    }

    public synchronized void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    public synchronized void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
    }
}

